$(
    function() {

        /**
         * Modal form submit code
         */
        $(document)
            .on(
                'beforeSubmit', '#feedback-form,#feedback-form2', function(e) {
                    var f = this;
                    var form = $(this);
                    var formData = form.serialize();
                    $.ajax(
                        {
                            url: form.attr("action"),
                            type: form.attr("method"),
                            data: formData,
                            success: function(data) {
                                f.reset();
                                $('#feedback-modal')
                                    .modal('hide');
                                $('#question-modal')
                                    .modal('hide');

                                $('#success-modal')
                                    .modal('show');
                                form.data("yiiActiveForm").validated = false;
                            },
                            error: function() {
                                $('#feedback-modal')
                                    .modal('hide');
                            }
                        }
                    );
                }
            )
            .on(
                'submit', '#feedback-form,#feedback-form2', function(e) {
                    e.preventDefault();
                    return false;
                }
            );

        /**
         * Contact form submitting
         */
        $(document)
            .on(
                'beforeSubmit', '#contact-form', function(e) {
                    var f = this;
                    var form = $(this);
                    var formData = form.serialize();
                    $.ajax(
                        {
                            url: form.attr("action"),
                            type: form.attr("method"),
                            data: formData,
                            success: function(data) {
                                f.reset();
                                form.replaceWith(data.alert)
                            },
                            error: function() {

                            }
                        }
                    );
                }
            )
            .on(
                'submit', '#contact-form', function(e) {
                    e.preventDefault();
                }
            );

        /**
         * Button UP code
         */
        if ($('#back-to-top').length) {
            var scrollTrigger = 100, // px
                backToTop = function() {
                    var scrollTop = $(window)
                        .scrollTop();
                    if (scrollTop > scrollTrigger) {
                        $('#back-to-top')
                            .addClass('show');
                    } else {
                        $('#back-to-top')
                            .removeClass('show');
                    }
                };
            backToTop();
            $(window)
                .on(
                    'scroll', function() {
                        backToTop();
                    }
                );
            $('#back-to-top')
                .on(
                    'click', function(e) {
                        e.preventDefault();
                        $('html,body')
                            .animate(
                                {
                                    scrollTop: 0
                                }, 700
                            );
                    }
                );
        }
    }
);