<?php
    
    /**
     * @var View           $this
     * @var string         $content
     * @var SeoComponent   $seo
     * @var User           $user
     * @var PageCategory[] $pageCategories
     */
    
    use artbox\core\components\SeoComponent;
    use artbox\core\helpers\ImageHelper;
    use common\models\Feedback;
    use artbox\core\models\PageCategory;
    use artbox\core\models\User;
    use common\models\Settings;
    use frontend\assets\AppAsset;
    use frontend\assets\MapAsset;
    use artbox\core\components\imagemanager\models\ImageManager;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Nav;
    use yii\bootstrap\Html;
    use yii\db\ActiveQuery;
    use yii\helpers\Url;
    use yii\web\View;
    use yii\widgets\Breadcrumbs;
    
    AppAsset::register($this);
    MapAsset::register($this);
    $user = \Yii::$app->user->identity;
    $seo = Yii::$app->get('seo');
    $feedback = new Feedback(['scenario' => Feedback::SCENARIO_FEEDBACK]);
    $settings = Settings::getInstance();
    $controller = Yii::$app->controller;
    $default_controller = Yii::$app->defaultRoute;
    $isHome = ( ( $controller->id === $default_controller ) && ( $controller->action->id === $controller->defaultAction ) ) ? true : false;
    
    $pageCategories = PageCategory::find()
                                  ->with(
                                      [
                                          'lang',
                                          'pages' => function (ActiveQuery $query) {
                                              $query->with('lang.alias')
                                                    ->where(['in_menu' => true])
                                                    ->orderBy([ 'sort' => SORT_ASC ]);
                                          },
                                      ]
                                  )
                                  ->where([ 'status' => true ])
                                  ->orderBy([ 'sort' => SORT_ASC ])
                                  ->all();
    $logo = null;
    if ($settings->logo) {
        $logo_img = ImageManager::findOne($settings->logo);
        if ($logo_img) {
            $logo = $logo_img->getImagePathPrivate() ?? $logo;
        }
    }
    
    $this->registerMetaTag(
        [
            'name'    => 'description',
            'content' => $seo->desc,
        ]
    )
?>

<?php $this->beginPage() ?>
  
  <!DOCTYPE html>
  <html lang="<?= \Yii::$app->language ?>">
    <head>
      <meta charset="<?= \Yii::$app->charset ?>">
      <meta name="viewport" content="width=device-width, initial-scale=1">
        <?= Html::csrfMetaTags() ?>
      <title>Time Invest Day</title>
      <title><?= Html::encode($seo->title) ?></title>
    
        <!-- Facebook Pixel Code -->
        <script>
            !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
                n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
                n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
                t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
                document,'script','https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '1591060651200152'); // Insert your pixel ID here.
            fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id=1591060651200152&ev=PageView&noscript=1"
            /></noscript>
        <!-- DO NOT MODIFY -->
        <!-- End Facebook Pixel Code -->
        
        <?php $this->head() ?>
    </head>
    <body>
        <?php $this->beginBody() ?>
      <!-- Google Analytics -->
      <script>
          (function(i, s, o, g, r, a, m) {
              i[ 'GoogleAnalyticsObject' ] = r;
              i[ r ] = i[ r ] || function() {
                      (i[ r ].q = i[ r ].q || []).push(arguments)
                  }, i[ r ].l = 1 * new Date();
              a = s.createElement(o), m = s.getElementsByTagName(o)[ 0 ];
              a.async = 1;
              a.src = g;
              m.parentNode.insertBefore(a, m)
          })(window, document, 'script', 'https://www.google-analytics.com/analytics.js', 'ga');

          ga('create', '<?=$settings->ga_code?>', 'auto');
          ga('send', 'pageview');
      
      </script>
      <div id="all">
        <header>
            <div id="top">
                <div class="container">
                    <div class="row">
                        <div class="col-xs-5 contact">
                            <p class="hidden-sm hidden-xs">тел. <a class="tel-header-btn" href="tel:+380985280323">+38 (098) 528 03 23</a> <span style="font-size: 17px;margin: 0 5px;">|</span> <a href="#" class="callback-modal-btn" data-toggle="modal" data-target="#question-modal">Обратная связь</a></p>
                        </div>
                    </div>
                </div>
            </div>
          <!-- *** NAVBAR ***
  _________________________________________________________ -->
          <div class="navbar-affixed-top" data-spy="affix" data-offset-top="200">
            
            <div class="navbar navbar-default yamm" role="navigation" id="navbar">
              
              <div class="container">
                <div class="navbar-header">
                  
                  <a class="navbar-brand home" href="<?php echo Url::home(); ?>">
                      <img src="/img/main-logo.png" alt="BeHappy24" style="width: 130px;">
                  </a>
                  <div class="navbar-buttons">
                    <button type="button" class="navbar-toggle btn-template-main" data-toggle="collapse" data-target="#navigation">
                      <span class="sr-only">Toggle navigation</span>
                      <i class="fa fa-align-justify"></i>
                    </button>
                  </div>
                </div>

                <div class="navbar-collapse collapse" id="navigation">
                    <ul id="w0" class="nav navbar-nav navbar-right"><li><a href="#sect1" class="scroll-to">Мероприятие</a></li>
                        <li><a href="#sect2" class="scroll-to">Где и когда</a></li>
                        <li><a href="#sect3" class="scroll-to">Программа</a></li>
                        <li><a href="#sect6" class="scroll-to">Спикеры</a></li>
                        <li><a href="#sect5" class="scroll-to">Кому будет интересно</a></li>
                        <li><a href="#sect7" class="scroll-to">Как добраться</a></li></ul>
                </div>

                
                <div class="collapse clearfix" id="search">
                  
                  <form class="navbar-form" role="search">
                    <div class="input-group">
                      <input type="text" class="form-control" placeholder="Search">
                      <span class="input-group-btn">

                    <button type="submit" class="btn btn-template-main"><i class="fa fa-search"></i></button>

                </span>
                    </div>
                  </form>
                
                </div>
                <!--/.nav-collapse -->
              
              </div>
            
            
            </div>
            <!-- /#navbar -->
          
          </div>
          
          <!-- *** NAVBAR END *** -->
        
        </header>
        
        <!-- *** FeedBack MODAL ***
_________________________________________________________ -->
        
        <div class="modal fade" id="feedback-modal" tabindex="-1" role="dialog" aria-labelledby="Login" aria-hidden="true">
          <div class="modal-dialog">
            
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times</button>
                <h3 class="modal-title" id="Login">Time Invest Day</h3>
              </div>
              <div class="modal-body">
                  
                  <?php $form = ActiveForm::begin(
                      [
                          'id'     => 'feedback-form',
                          'method' => 'POST',
                          'action' => '/site/feedback',
                      ]
                  ); ?>
                  <div class="col-md-12">
                      <div class="col-md-4">
                          <?= $form->field($feedback, 'name')
                              ->textInput()->Label('Имя и фамилия'); ?>
                      </div>
                      <div class="col-md-4">
                          <?= $form->field($feedback, 'email')
                              ->textInput()->Label('Адрес электронной почты'); ?>
                      </div>
                      <div class="col-md-4">
                          <?= $form->field($feedback, 'phone')
                              ->textInput()->Label('Номер телефона'); ?>
                      </div>
                  </div>
                  <div class="col-md-12">
                      <div class="col-md-6">
                          <?= $form->field($feedback, 'promocode')
                              ->textInput()->Label('Впишите промокод для получения скидки -20%'); ?>
                      </div>
                      <div class="col-md-6">
    
                          <?= $form->field($feedback, 'inviter')
                                   ->textInput()->Label('ФИО пригласителя'); ?>
                          
<!--                          <label class="control-label" for="feedback-inviter">ФИО пригласителя</label>-->
<!--                          <input type="text" id="feedback-inviter" class="form-control" name="Feedback[inviter]" aria-invalid="false">-->
                      </div>
                  </div>
                  <div class="col-md-10 col-md-offset-1 form-down">
                      <div style="font-weight:bold;font-size: 18px;padding-bottom: 5px;">Как вам удобно оплатить?<span style="color:red;">*</span></div>
                      <?= $form->field($feedback, 'oplata')
                               ->radioList(
                                   [
                                       "Перевод на карту Приватбанка без промокода (150 грн)" => 'Перевод на карту Приватбанка (до 15 декабря стоимость билета 150 грн)',
                                       "Перевод на карту Приватбанка с промокода (120 грн)" => 'Перевод на карту Приватбанка (с промокодом стоимость до 15 декабря 120 грн)',
                                       "Наличными представителю" => 'Наличными представителю (в день мероприятия, 16 декабря, цена 200 грн)',
                                   ],
                                   [
                                       'unselect' => null,
                                   ]
                               )->label(false);
                      ?>
                  </div>
                    <div class="col-md-12">
                        <p class="text-center">
                            <?= Html::submitButton(
                                'Отправить',
                                [
                                    'class' => 'send-form btn btn-lg btn-template-primary',
                                ]
                            ) ?>
                        </p>
                    </div>
                  <div style="clear:both;"></div>
                  
                  <?php ActiveForm::end(); ?>
              
              </div>
            </div>
          </div>
        </div>

          <div class="modal fade" id="writeus-modal" tabindex="-1" role="dialog" aria-labelledby="Login" aria-hidden="true">
              <div class="modal-dialog">

                  <div class="modal-content">
                      <div class="modal-header">
                          <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times</button>
                          <h4 class="text-center" id="Login">Оставьте свои контакты, чтобы гарантированно зарезервировать место в зале</h4>
                      </div>
                      <div class="modal-body">

                          <?php $form = ActiveForm::begin(
                              [
                                  'id'     => 'feedback-form',
                                  'method' => 'POST',
                                  'action' => '/site/feedback',
                              ]
                          );
                          $feedback = new Feedback(['scenario' => Feedback::SCENARIO_DEFAULT]);
                          ?>
                          <div class="col-md-12">
                              <div class="col-md-12">
                                  <?= $form->field($feedback, 'name')
                                      ->textInput()->Label('Имя и фамилия'); ?>
                              </div>
                              <div class="col-md-12">
                                  <?= $form->field($feedback, 'email')
                                      ->textInput()->Label('Адрес электронной почты'); ?>
                              </div>
                          </div>
                          <div class="col-md-12">
                              <div class="col-md-12">
                                  <?= $form->field($feedback, 'phone')
                                      ->textInput()->Label('Номер телефона'); ?>
                              </div>
                              <div class="col-md-12">
                                  <?= $form->field($feedback, 'message')
                                      ->textInput()->Label('Комментарий'); ?>
                              </div>
                          </div>
                          <div class="col-md-12">
                              <p class="text-center">
                                  <?= Html::submitButton(
                                      'Отправить',
                                      [
                                          'class' => 'send-form btn btn-lg btn-template-primary',
                                      ]
                                  ) ?>
                              </p>
                          </div>
                          <div style="clear:both;"></div>

                          <?php ActiveForm::end(); ?>

                      </div>
                  </div>
              </div>
          </div>

        <div class="modal fade" id="question-modal" tabindex="-1" role="dialog" aria-labelledby="Login" aria-hidden="true">
          <div class="modal-dialog">

            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times</button>
                <h3 class="modal-title" id="Login">Возникли вопросы?</h3>
                  <h4 class="text-center">Мы Вам перезвоним или напишем подробнее обо всем, что Вас интересует</h4>
              </div>
              <div class="modal-body">

                  <?php $form = ActiveForm::begin(
                      [
                          'id'     => 'feedback-form2',
                          'method' => 'POST',
                          'action' => '/site/feedback',
                      ]
                  );
                      $feedback = new Feedback(['scenario' => Feedback::SCENARIO_DEFAULT]);
                      
                      echo Html::hiddenInput('def', "1");
                  ?>
                  <div class="col-md-12">
                      <div class="col-md-12">
                          <?= $form->field($feedback, 'name')
                              ->textInput()->Label('Имя и фамилия'); ?>
                      </div>
                      <div class="col-md-12">
                          <?= $form->field($feedback, 'email')
                              ->textInput()->Label('Адрес электронной почты'); ?>
                      </div>
                  </div>
                  <div class="col-md-12">
                      <div class="col-md-12">
                          <?= $form->field($feedback, 'phone')
                              ->textInput()->Label('Номер телефона'); ?>
                      </div>
                      <div class="col-md-12">
                          <?= $form->field($feedback, 'message')
                              ->textInput()->Label('Комментарий'); ?>
                      </div>
                  </div>
                    <div class="col-md-12">
                        <p class="text-center">
                            <?= Html::submitButton(
                                'Отправить',
                                [
                                    'class' => 'send-form btn btn-lg btn-template-primary',
                                ]
                            ) ?>
                        </p>
                    </div>
                  <div style="clear:both;"></div>

                  <?php ActiveForm::end(); ?>

              </div>
            </div>
          </div>
        </div>
        
        <!-- *** FeedBack MODAL END *** -->
        
        <!-- *** FeedBack MODAL ***
_________________________________________________________ -->
        
        <div class="modal fade" id="success-modal" tabindex="-1" role="dialog" aria-labelledby="Success" aria-hidden="true">
          <div class="modal-dialog">
            
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times</button>
                <h3 class="modal-title" id="Success">Поздравляем!</h3>
              </div>
              <div class="modal-body">
                
                <p>Вы стали участником форума "TIME INVEST DAY". Для уточнения деталей наш менеджер свяжется с Вами в ближайшее время.</p>
                <p class="text-center">
                  <button type="button" class="btn btn-template-primary" data-dismiss="modal">Закрыть</button>
                </p>
              </div>
            </div>
          </div>
        </div>
        
        <!-- *** FeedBack MODAL END *** -->
        
        <!-- *** Breadcrumbs *** -->
          <?php
              if (!$isHome) {
                  ?>
                <div id="heading-breadcrumbs">
                  <div class="container">
                    <div class="row">
                      <div class="col-md-7">
                        <h1><?= $seo->h1 ?></h1>
                      </div>
                      <div class="col-md-5">
                          <?= Breadcrumbs::widget(
                              [
                                  'links' => isset($this->params[ 'breadcrumbs' ]) ? $this->params[ 'breadcrumbs' ] : [],
                              ]
                          ) ?>
                      
                      </div>
                    </div>
                  </div>
                </div>
                  <?php
              }
          ?>
        <!-- *** Breadcrumbs END *** -->
          
          <?= $content ?>

        <span id="back-to-top" title="Back to top"><i class="fa fa-arrow-up"></i></span>
      
      </div>
      <!-- /#all -->
        <?php $this->endBody() ?>
    </body>
  </html>
<?php $this->endPage() ?>