<?php
    namespace common\models;
    
    use Yii;
    use yii\helpers\ArrayHelper;
    use yii2tech\filedb\ActiveRecord;
    
    /**
     * Class SitemapStatic
     *
     * @property int    $id
     * @property string $url
     * @property float  $priority
     * @property string $frequency
     */
    class SitemapStatic extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function getDb()
        {
            return \Yii::$app->get('sitemapdb');
        }
        
        /**
         * @inheritdoc
         */
        public function attributes()
        {
            return [
                'id',
                'url',
                'priority',
                'frequency',
            ];
        }
        
        /**
         * @inheritdoc
         */
        public static function primaryKey()
        {
            return [ 'id' ];
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'url',
                        'priority',
                    ],
                    'required',
                ],
                [
                    [
                        'priority',
                    ],
                    'double',
                    'min' => 0,
                    'max' => 1,
                ],
                [
                    [
                        'url',
                        'frequency',
                    ],
                    'string',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'        => Yii::t('core', 'ID'),
                'url'       => Yii::t('core', 'Url'),
                'priority'  => Yii::t('core', 'Priority'),
                'frequency' => Yii::t('core', 'Frequency'),
            ];
        }
        
        /**
         * Find maximum ID value from SitemapStatic models
         */
        public static function max(): int
        {
            $models = self::find()
                          ->all();
            $array = ArrayHelper::getColumn($models, self::primaryKey()[ 0 ], false);
            if (empty( $array )) {
                return 0;
            } else {
                return max($array);
            }
        }
    }