<?php
    namespace common\models;

    use artbox\core\components\imagemanager\models\ImageManager;
    use yii2tech\filedb\ActiveRecord;
    use Yii;
    
    /**
     * Class Settings
     *
     * @package artbox\core\models
     * @property string $analytics_key
     * @property string $robots
     * @property string $ga_code
     * @property string $ya_code
     * @property string $tag_manager
     * @property string $phone
     * @property string $phone2
     * @property string $skype
     * @property string $email
     * @property string $house
     * @property string $street
     * @property string $office
     * @property string $city
     * @property string $country
     * @property float  $lat
     * @property float  $lon
     * @property string $facebook
     * @property string $vk
     * @property string $ok
     * @property string $google
     * @property string $twitter
     * @property string name
     * @property int    $logo
     * @property string $about
     */
    class Settings extends ActiveRecord
    {
        const SCENARIO_ROBOTS = 'robots';
        const SCENARIO_CODES = 'codes';
        
        private static $instance;
        
        /**
         * @inheritdoc
         */
        public function scenarios()
        {
            return array_merge(
                parent::scenarios(),
                [
                    self::SCENARIO_ROBOTS => [ 'robots' ],
                    self::SCENARIO_CODES  => [
                        'ga_code',
                        'ya_code',
                        'tag_manager',
                    ],
                ]
            );
        }
    
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'analytics_key',
                        'robots',
                        'ga_code',
                        'ya_code',
                        'tag_manager',
                        'phone',
                        'phone2',
                        'skype',
                        'email',
                        'house',
                        'street',
                        'office',
                        'city',
                        'country',
                        'facebook',
                        'vk',
                        'google',
                        'twitter',
                        'name',
                        'about',
                        'ok',
                    ],
                    'string',
                ],
                [
                    [
                        'lat',
                        'lon',
                    ],
                    'double',
                ],
                [
                    [
                        'email',
                    ],
                    'email',
                ],
                [
                    [
                        'logo',
                    ],
                    'integer',
                ],
                [
                    [
                        'logo',
                    ],
                    'exist',
                    'targetClass'     => ImageManager::className(),
                    'targetAttribute' => 'id',
                ],
                [
                    [
                        'logo',
                    ],
                    'filter',
                    'filter' => function ($value) {
                        if (empty( $value )) {
                            return null;
                        } else {
                            return $value;
                        }
                    },
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public static function fileName()
        {
            return 'settings';
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'analytics_key' => Yii::t('core', 'Google Analytics Key'),
                'robots'        => Yii::t('core', 'Robots'),
                'ga_code'       => Yii::t('core', 'Google analytics code'),
                'ya_code'       => Yii::t('core', 'Yandex metrics code'),
                'tag_manager'   => Yii::t('core', 'Tag Manager code'),
                'phone'         => Yii::t('core', 'Phone'),
                'phone2'        => Yii::t('core', 'Additional phone'),
                'skype'         => Yii::t('core', 'Skype'),
                'name'          => Yii::t('core', 'Company name'),
                'email'         => Yii::t('core', 'Email'),
                'house'         => Yii::t('core', 'House'),
                'street'        => Yii::t('core', 'Street'),
                'office'        => Yii::t('core', 'Office'),
                'city'          => Yii::t('core', 'City'),
                'country'       => Yii::t('core', 'Country'),
                'lat'           => Yii::t('core', 'Latitude'),
                'lon'           => Yii::t('core', 'Longitude'),
                'facebook'      => Yii::t('core', 'Facebook'),
                'vk'            => Yii::t('core', 'VK'),
                'google'        => Yii::t('core', 'Google'),
                'twitter'       => Yii::t('core', 'Twitter'),
                'logo'          => Yii::t('core', 'Company logo'),
                'about'         => Yii::t('core', 'About us'),
                'ok'            => Yii::t('core', 'Odnoklassniki'),
            ];
        }
    
        public function afterFind()
        {
            if ($this->logo === '') {
                $this->logo = null;
            }
            parent::afterFind();
        }
    
        /**
         * Get Settings model instance
         *
         * @return Settings
         */
        public static function getInstance()
        {
            if (empty( self::$instance )) {
                self::$instance = self::findOne([ 'id' => 1 ]);
                return self::$instance;
            }
    
            return self::$instance;
        }
    }
    