<?php
    /**
     * Created by PhpStorm.
     * User: timur
     * Date: 05.12.17
     * Time: 13:45
     */
    
    namespace common\models;
    
    use artbox\core\models\Feedback as FeefbackCore;
    use Yii;
    
    class Feedback extends FeefbackCore
    {
    
        public function scenarios()
        {
            $scenarios = parent::scenarios();
            $scenarios = array_merge(
                $scenarios,
                [
                    self::SCENARIO_DEFAULT => [
                        'name',
                        'email',
                        'phone',
                        'message',
                    ],
                    self::SCENARIO_FEEDBACK => [
                        'name',
                        'email',
                        'message',
                        'returnUrl',
                        'phone',
                        'oplata',
                        'promocode',
                        'inviter',
                    ],
                    self::SCENARIO_CALLBACK => [
                        'name',
                        'phone',
                        'message',
                        'returnUrl',
                        'message',
                    ],
                ]
            );
            return $scenarios;
        }
    
        public function rules()
        {
            return [
                [
                    [
                        'name',
                        'email',
                        'phone',
                    ],
                    'required',
                    'on' => self::SCENARIO_DEFAULT,
                ],
                [
                    [
                        'name',
                        'email',
                        'phone',
                        'oplata'
                    ],
                    'required',
                    'on' => self::SCENARIO_FEEDBACK,
                ],
                [
                    [
                        'phone',
                        'name',
                    ],
                    'required',
                    'on' => self::SCENARIO_CALLBACK,
                ],
                [
                    [ 'email' ],
                    'email',
                ],
                //                [
                //                    [ 'phone' ],
                //                    'match',
                //                    'pattern' => '/^\+38\(\d{3}\)\d{3}-\d{2}-\d{2}$/',
                //                ],
                [
                    [
                        'name',
                        'phone',
                        'email',
                        'oplata',
                        'promocode',
                        'inviter',
                    ],
                    'string',
                    'max' => 255,
                ],
                [
                    [
                        'message',
                    ],
                    'string',
                ],
                [
                    [
                        'status',
                    ],
                    'boolean',
                ],
                [
                    'returnUrl',
                    'safe',
                ],
            ];
        }
    
        public function attributeLabels()
        {
            return [
                'id'         => Yii::t('core', 'id'),
                'name'       => Yii::t('core', 'name'),
                'phone'      => Yii::t('core', 'phone'),
                'created_at' => Yii::t('core', 'created_at'),
                'ip'         => Yii::t('core', 'ip'),
                'url'        => Yii::t('core', 'url'),
                'status'     => Yii::t('core', 'status'),
                'message'    => Yii::t('core', 'message'),
                'email'      => Yii::t('core', 'email'),
                'oplata'      => Yii::t('app', 'oplata'),
                'promocode'      => Yii::t('app', 'promocode'),
            ];
        }
        
    }
    