<?php
    use artbox\core\components\SeoComponent;
    
    $mail = require( 'mail.php' );
    
    return [
        'vendorPath' => dirname(dirname(__DIR__)) . '/vendor',
        'modules'    => [
            'imagemanager' => [
                'class'                => 'artbox\core\components\imagemanager\Module',
                'canUploadImage'       => true,
                'canRemoveImage'       => function () {
                    return true;
                },
                'setBlameableBehavior' => false,
                'cssFiles'             => [
                    'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.6.3/css/font-awesome.min.css',
                ],
            ],
        ],
        'components' => [
            'cache'        => [
                'class' => 'yii\caching\FileCache',
            ],
            'i18n'         => [
                'translations' => [
                    'core' => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@artbox/core/messages',
                    ],
                    'app'  => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@common/messages',
                    ],
                ],
            ],
            'filedb'       => [
                'class' => 'yii2tech\filedb\Connection',
                'path'  => '@common/config',
            ],
            'sitemapdb'    => [
                'class'          => 'yii2tech\filedb\Connection',
                'path'           => '@common/config',
                'primaryKeyName' => 'id',
            ],
            'seo'          => [
                'class' => SeoComponent::className(),
            ],
            'imagemanager' => [
                'class'       => 'artbox\core\components\imagemanager\components\ImageManagerGetPath',
                'mediaPath'   => dirname(dirname(__DIR__)) . '/storage',
                'cachePath'   => '../../storage/cache',
                'useFilename' => true,
                'absoluteUrl' => false,
            ],
            'smtpmailer'   => [
                'class'     => 'yii\swiftmailer\Mailer',
                'transport' => [
                    'class'      => 'Swift_SmtpTransport',
                    'host'       => $mail[ 1 ][ 'host' ],
                    'username'   => $mail[ 1 ][ 'user' ],
                    'password'   => $mail[ 1 ][ 'pass' ],
                    'port'       => '587',
                    'encryption' => 'tls',
                ],
                'viewPath' => '@common/mail'
            ],
        ],
    ];
