<?php
    use common\components\Sitemap;
    use yii\bootstrap\Html;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View $this
     */
    $this->title = \Yii::t('core', 'Sitemap');
    $this->params[ 'breadcrumbs' ][] = $this->title;
    /**
     * @var Sitemap $sitemap
     */
    $sitemap = \Yii::$app->get('sitemap');
?>
<div class="sitemap-main">
    <?php
        $xPanel = Panel::begin(
            [
                'header'  => $this->title,
                'options' => [
                    'class' => 'x_panel sitemap-buttons',
                ],
            ]
        );
    ?>
    <div class="row">
        <div class="col-xs-12 col-sm-6 text-center">
            <?php
                echo Html::a(
                    Html::icon(
                        'edit',
                        [
                            'prefix' => 'fa fa-',
                        ]
                    ) . \Yii::t('core', 'Edit'),
                    [ 'update' ],
                    [
                        'class' => 'btn btn-app',
                    ]
                );
            ?>
        </div>
        <div class="col-xs-12 col-sm-6 text-center">
            <?php
                echo Html::a(
                    Html::icon(
                        'cogs',
                        [
                            'prefix' => 'fa fa-',
                            'class'  => 'indexed',
                        ]
                    ) . Html::tag(
                        'span',
                        \Yii::t('core', 'Generate'),
                        [
                            'class' => 'indexed',
                        ]
                    ) . Html::tag(
                        'div',
                        ' ',
                        [
                            'class' => 'spinner',
                        ]
                    ),
                    [ 'generate' ],
                    [
                        'class' => 'btn btn-app ajax',
                        'data'  => [
                            'need-reload' => !$sitemap->checkFileExist(),
                        ],
                    ]
                );
            ?>
        </div>
    </div>
    <?php
        if ($sitemap->checkFileExist()) {
            echo Html::tag(
                'div',
                Html::a(
                    \Yii::t('core', 'View generated sitemap.xml'),
                    $sitemap->getUrl(),
                    [
                        'target' => '_blank',
                    ]
                ),
                [
                    'class' => 'row text-right',
                ]
            );
        }
    ?>
    <?php
        $xPanel::end();
    ?>
</div>
