<?php
    
    /**
     * @var View $this
     */
    
    use backend\assets\AnalyticsAsset;
    use yii\bootstrap\Tabs;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    $this->title = 'Artbox !';
    
    AnalyticsAsset::register($this);
?>
<div class="animated yt-loader"></div>

<div class="row">
  <div class="animated flipInY col-lg-3 col-md-3 col-sm-6 col-xs-12">
    <div class="tile-stats">
      <div class="icon"><i class="fa fa-clock-o"></i>
      </div>
      
      <div class="count" id="sessions">0</div>
      
      <h3>Sessions</h3>
      <p>Lorem ipsum psdea itgum rixt.</p>
    </div>
  </div>
  <div class="animated flipInY col-lg-3 col-md-3 col-sm-6 col-xs-12">
    <div class="tile-stats">
      <div class="icon"><i class="fa fa-user"></i>
      </div>
      
      <div class="count" id="users">0</div>
      
      <h3>Users</h3>
      <p>Lorem ipsum psdea itgum rixt.</p>
    </div>
  </div>
  <div class="animated flipInY col-lg-3 col-md-3 col-sm-6 col-xs-12">
    <div class="tile-stats">
      <div class="icon"><i class="fa fa-eye"></i>
      </div>
      
      <div class="count" id="views">0</div>
      
      <h3>Page views</h3>
      <p>Lorem ipsum psdea itgum rixt.</p>
    </div>
  </div>
  <div class="animated flipInY col-lg-3 col-md-3 col-sm-6 col-xs-12">
    <div class="tile-stats">
      <div class="icon"><i class="fa fa-plus"></i>
      </div>
      
      <div class="count" id="newusers">0</div>
      
      <h3>New sessions</h3>
      <p>Lorem ipsum psdea itgum rixt.</p>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-12">
      <?php $panel = Panel::begin(
          [
              'header' => 'Analytic',
          ]
      ) ?>
    
    <div id="chartdiv" style="width: 100%;height: 500px"></div>
      
      <?php $panel::end(); ?>
  </div>
</div>

<div class="row">
  <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
      <?php $panel = Panel::begin(
          [
              'header' => 'Pie chart',
          ]
      ) ?>
    
    <div id="piediv" style="width: 100%;height: 475px"></div>
      
      <?php $panel::end(); ?>
  </div>
  
  <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
      
      <?php $panel = Panel::begin(
          [
              'header' => 'Some stats',
          ]
      ); ?>
      
      <?php
          echo Tabs::widget(
              [
                  'options' => [
                      'class' => 'bar_tabs',
                  ],
                  'items'   => [
                      [
                          'label'   => 'Browsers',
                          'content' => '<div id="browsers"></div>',
                          'active'  => true,
                      ],
                      [
                          'label'   => 'Cities',
                          'content' => '<div id="cities"></div>',
                      ],
                      [
                          'label'   => 'Countries',
                          'content' => '<div id="countries"></div>',
                      ],
                  ],
              ]
          );
      
      ?>
      
      <?php $panel::end(); ?>
  
  </div>
</div>
