<?php
    /**
     * @var View     $this
     * @var Settings $model
     */
    
    use common\models\Settings;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    $this->title = $model->getAttributeLabel('robots');
    
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>

<?php $panel = Panel::begin(
    [
        'header' => $this->title,
    ]
); ?>

<div class="settings-form">
    
    <?php
        $form = ActiveForm::begin();
        
        echo $form->field($model, 'robots')
                  ->label(false)
                  ->textarea([ 'rows' => 15 ]);
        
        echo Html::submitButton(
            \Yii::t('core', 'Save'),
            [
                'class' => 'btn btn-primary',
            ]
        );
        ActiveForm::end();
    ?>

</div>

<?php $panel::end(); ?>
