<?php
    use yii\web\UrlManager;
    
    $homeLink = [];
    /**
     * @var UrlManager $urlManagerFrontend
     */
    if ($urlManagerFrontend = \Yii::$app->get('urlManagerFrontend', false)) {
        $homeLink = [
            [
                'label'    => \Yii::t('core', 'My website'),
                'url'      => $urlManagerFrontend->createUrl([ 'site/index' ]),
                'icon'     => 'home',
                'template' => '<a href="{url}" target="_blank">{icon}<span>{label}</span>{badge}</a>',
                'options'  => [
                    'class' => 'homepage_link',
                ],
            ],
        ];
    }
    return array_merge(
        $homeLink,
        [
            [
                'label'  => \Yii::t('core', 'Main'),
                'url'    => [ '/site/index' ],
                'icon'   => ( \Yii::$app->controller->id === 'site' ) ? 'check' : 'undo',
                'active' => function () {
                    return \Yii::$app->controller->id === 'site';
                },
            ],
            [
                'label'  => \Yii::t('core', 'Static pages'),
                'url'    => '#',
                'icon'   => 'file-text',
                'items' => [
                    [
                        'label'  => \Yii::t('core', 'Pages'),
                        'url'    => [ '/page/index' ],
                        'icon'   => 'file-text',
                    ],
                    [
                        'label'  => \Yii::t('core', 'Categories'),
                        'url'    => [ '/page-category/index' ],
                        'icon'   => 'archive',
                    ]
                ],
            ],
            [
                'label' => \Yii::t('core', 'SEO'),
                'url'   => '#',
                'icon'  => 'bolt',
                'items' => [
                    [
                        'label' => \Yii::t('core', 'Seo pages'),
                        'url'   => [ '/alias/index' ],
                        'icon'  => 'file-text',
                    ],
                    [
                        'label' => \Yii::t('core', 'Robots'),
                        'url'   => [ '/settings/robots' ],
                        'icon'  => 'android',
                    ],
                    [
                        'label' => \Yii::t('core', 'Codes'),
                        'url'   => [ '/settings/codes' ],
                        'icon'  => 'code',
                    ],
                    [
                        'label' => \Yii::t('core', 'Sitemap'),
                        'url'   => [ '/sitemap/index' ],
                        'icon'  => 'map-signs',
                    ],
                ],
            ],
            [
                'label'  => \Yii::t('core', 'Image manager'),
                'url'    => [ '/imagemanager' ],
                'icon'   => 'image',
            ],
        ]
    );