<?php
    
    /**
     * @var string $content
     * @var View   $this
     */
    
    use artbox\core\assets\ArtboxCoreAsset;
    use artbox\core\components\imagemanager\components\ImageManagerGetPath;
    use artbox\core\models\User;
    use artbox\core\models\UserData;
    use artbox\core\widgets\FeedbackWidget;
    use artbox\core\widgets\FlashWidget;
    use yii\bootstrap\Html;
    use yii\web\View;
    use yii\widgets\Breadcrumbs;
    use yiister\gentelella\widgets\Menu;
    
    ArtboxCoreAsset::register($this);
    
    /**
     * @var User $user
     */
    $user = \Yii::$app->user->identity;
    /**
     * @var UserData $userData
     */
    $userData = $user->ensureExistance();
    /**
     * @var ImageManagerGetPath $imageManager
     */
    $imageManager = \Yii::$app->get('imagemanager');
    $avatar = $imageManager->getImagePath($userData->image, 128, 128);
?>
<?php $this->beginPage(); ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta charset="<?= Yii::$app->charset ?>"/>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <meta name="viewport" content="width=device-width, initial-scale=1"/>
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
    </head>
    <body class="nav-md">
        <?php $this->beginBody(); ?>
        <div class="container body">
            
            <div class="main_container">
                
                <div class="col-md-3 left_col">
                    <div class="left_col scroll-view">
                        
                        <div class="navbar nav_title" style="border: 0;">
                            <?php
                                echo Html::a(
                                    Html::icon(
                                        'rocket',
                                        [
                                            'prefix' => 'fa fa-',
                                        ]
                                    ) . Html::tag('span', 'Artbox!'),
                                    [ 'site/index' ],
                                    [
                                        'class' => 'site_title',
                                    ]
                                );
                            ?>
                        </div>
                        <div class="clearfix"></div>
                        
                        <!-- menu prile quick info -->
                        <div class="profile">
                            <div class="profile_pic">
                                <?php
                                    echo Html::a(
                                        Html::img(
                                            ( empty( $avatar ) ? 'http://placehold.it/128x128' : $avatar ),
                                            [
                                                'alt'   => $userData->fullname,
                                                'title' => \Yii::t('core', 'Change image'),
                                                'class' => 'img-circle profile_img',
                                            ]
                                        ),
                                        [ 'profile/index' ]
                                    )
                                ?>
                            </div>
                            <div class="profile_info">
                                <span><?= \Yii::t('core', 'Welcome,'); ?></span>
                                <h2>
                                    <?php
                                        echo Html::a(
                                            $userData->fullname,
                                            [ 'profile/index' ],
                                            [
                                                'title' => \Yii::t('core', 'Change name'),
                                            ]
                                        );
                                    ?>
                                </h2>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <!-- /menu prile quick info -->
                        
                        <br/>
                        
                        <!-- sidebar menu -->
                        <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
                            
                            <div class="menu_section">
                                <?php
                                    echo Menu::widget(
                                        [
                                            "items" => require( 'menu_items.php' ),
                                        ]
                                    ); ?>
                            </div>
                        
                        </div>
                        <!-- /sidebar menu -->
                    
                    </div>
                </div>
                
                <!-- top navigation -->
                <div class="top_nav">
                    
                    <div class="nav_menu">
                        <nav class="" role="navigation">
                            <div class="nav toggle">
                                <a id="menu_toggle"><i class="fa fa-bars"></i></a>
                            </div>
                            
                            <ul class="nav navbar-nav navbar-right">
                                <li class="">
                                    <a href="javascript:;" class="user-profile dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                        <?php
                                            echo Html::img(
                                                ( empty( $avatar ) ? 'http://placehold.it/128x128' : $avatar )
                                            );
                                            echo $user->username;
                                        ?>
                                        <span class=" fa fa-angle-down"></span>
                                    </a>
                                    <ul class="dropdown-menu dropdown-usermenu pull-right">
                                        <li>
                                            <?= Html::a(
                                                Html::tag(
                                                    'i',
                                                    '',
                                                    [ 'class' => 'fa fa-user pull-right' ]
                                                ) . ' Profile',
                                                [ '/profile' ]
                                            ) ?>
                                        </li>
                                        <li>
                                            <?= Html::a(
                                                Html::tag(
                                                    'i',
                                                    '',
                                                    [ 'class' => 'fa fa-cogs pull-right' ]
                                                ) . ' Settings',
                                                [ '/settings' ]
                                            ) ?>
                                        </li>
                                        <li>
                                            <?= Html::a(
                                                Html::tag(
                                                    'i',
                                                    '',
                                                    [ 'class' => 'fa fa-sign-out pull-right' ]
                                                ) . ' Log out',
                                                [ '/site/logout' ],
                                                [
                                                    'data-method' => 'POST',
                                                ]
                                            ) ?>
                                        </li>
                                    </ul>
                                </li>
                                <li role="presentation">
                                    <?= FeedbackWidget::widget(); ?>
                                </li>
                            </ul>
                        </nav>
                    </div>
                
                </div>
                <!-- /top navigation -->
                
                <!-- page content -->
                <div class="right_col" role="main">
                    <?php if (isset( $this->params[ 'h1' ] )): ?>
                        <div class="page-title">
                            <div class="title_left">
                                <h1><?= $this->params[ 'h1' ] ?></h1>
                            </div>
                            <div class="title_right">
                                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Search for...">
                                        <span class="input-group-btn">
                                <button class="btn btn-default" type="button">Go!</button>
                            </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="clearfix"></div>
    
                    <?= Breadcrumbs::widget(
                        [
                            'links' => isset( $this->params[ 'breadcrumbs' ] ) ? $this->params[ 'breadcrumbs' ] : [],
                        ]
                    ) ?>
    
                    <?= $content ?>
                </div>
                <!-- /page content -->
                <!-- footer content -->
                <footer>
                
                </footer>
                <!-- /footer content -->
            </div>
        
        </div>
    
        <?php
            echo FlashWidget::widget();
        ?>
        <!-- /footer content -->
        <?php $this->endBody(); ?>
    </body>
</html>
<?php $this->endPage(); ?>
