// road_passports wrapper
var road_passports = [];
if(points_url !== undefined)
{
    $(document).on(
        'click', '.road_passport_list_item .edit_path', function()
        {
            var id = $(this).data('passport-id');
            $.get(
                points_url, {id : id}, function(data)
                {
                    $('#control').empty().append(data.result.html);
                    road_passports[id] = new google.maps.MVCArray();
                    if(data.result.passport) {
                        road_passports[id].model = createPassportModel();
                        fillPassportModel(id, data.result.passport);
                    }
                    road_passports[id].setAt(0, undefined);
                    map.addListener('click', addLatLng);
                    clearMarkers();
                    $.each(
                        data.result.points, function(index, value)
                        {
                            road_passports[id].setAt(index, value);
                            var marker = new google.maps.Marker(
                                {
                                    position : {
                                        lat : parseFloat(value.lat),
                                        lng : parseFloat(value.lng)
                                    },
                                    title : '#' + parseInt(value.num),
                                    map : map,
                                    draggable : true,
                                    label : parseInt(value.num).toString(10)
                                }
                            );
                            markers.push(marker);
                            marker.addListener('dragend', dragend);
                        }
                    );
                    repaint();
                    fitBounds();
                }
            );
        }
    );
}
$(document).on(
    'change', '#passport_form input.latlng', function(e)
    {
        e.preventDefault();
        var container = $(this).parents('.passport_point_item').first();
        var key = $(container).data('key');
        var lat = parseFloat($('#point-' + key + '-lat').val());
        var lng = parseFloat($('#point-' + key + '-lng').val());
        markers.getAt(key - 1).setPosition(
            {
                lat : lat,
                lng : lng
            }
        );
        repaint();
        updateRow(key, {lat: lat, lng: lng});
    }
);
$(document).on(
    'change', '#passport_form input.km', function(e)
    {
        e.preventDefault();
        var container = $(this).parents('.passport_point_item').first();
        var key = $(container).data('key');
        updateRow(key, {km: $(this).val()});
    }
);
$(document).on(
    'submit', '#passport_form', function(e)
    {
        e.preventDefault();
        var submit = $(this).find('.passport_submit');
        $(submit).addClass('loading');
        $.post(
            save_url, $(this).serialize(), function(data) {
                $(submit).popover({
                    content: data.result.message,
                    placement: 'top'
                });
            }
        ).fail(function(data) {
            $(submit).popover({
                content: data.responseText,
                placement: 'top'
            });
        }).always(function(data) {
            $(submit).removeClass('loading').popover('show');
            $('body, html').on('click', function() {
                $(submit).popover('destroy');
            });
        });
    }
);

$(document).on('click', '#passport_control .passport_point_remove', function() {
    var container = $(this).parents('.passport_point_item').first();
    var wrapper = $(container).parents('#passport_control');
    var index = $(container).data('key');
    var passport_id = $(wrapper).data('passport_id');
    deleteRow(passport_id, index);
});

$(document).on('click', '#passport_control .passport_point_add', function() {
    var container = $(this).parents('.passport_point_item').first();
    var index = $(container).data('key');
    map.lastIndex = index;
    google.maps.event.clearListeners(map, 'click');
    map.addListener('click', addAt);
    showNotifier('Натисніть на карті, щоб додати точку');
    showMap();
});
$(document).on('click', '#passport_control .control', function() {
    $(this).parents('.point_control.collapse').collapse('hide');
});
$(document).on('keyup keypress', '#passport_form input', function(e) {
    var keyCode = e.keyCode || e.which;
    if(keyCode == 13) {
        e.preventDefault();
        $(this).trigger('change');
    }
});
$(document).on('click', '#snap_me', function() {
    if(markers.length) {
        runSnapToRoad();
    }
});