<?php

    /* @var $this yii\web\View */

    use common\models\GoogleRoad;
    use yii\bootstrap\Html;

    $this->title = 'My Yii Application';
    $this->registerJsFile('/js/test.js');
?>
<div class="site-index">
    <div class="list-group">
        <a href="#statements-menu" data-toggle="collapse" class="list-group-item" aria-controls="statements-menu">
            Відомості
        </a>
        <div class="collapse" id="statements-menu">
            <div class="well well-sm well-nm">
                <ul class="list-unstyled">
                    <?php
                        echo Html::a(Html::tag('li', 'Автомобільні дороги'), ['/statement']);
                        echo Html::a(Html::tag('li', 'Обслуговування'), ['/road-service']);
                        echo Html::a(Html::tag('li', 'Прив\'язки населених пунктів'), ['/settlement-address-link']);
                        echo Html::a(Html::tag('li', 'Інтенсивності'), ['/flow-intensity']);
                        echo Html::a(Html::tag('li', 'Категорія доріг'), ['/road-to-category']);
                        echo Html::a(Html::tag('li', 'З\'їзди'), ['/cross-section']);
                        echo Html::a(Html::tag('li', 'Ширина проїзних частин'), ['/road-width']);
                        echo Html::a(Html::tag('li', 'Покриття доріг'), ['/road-surface']);
                        echo Html::a(Html::tag('li', 'Об\'єкти сервісу'), ['/service-object']);
                        echo Html::a(Html::tag('li', 'Автобусні зупинки'), ['/bus-stop']);
                    ?>
                </ul>
            </div>
        </div>
        <?php
            echo Html::a('Список доріг', ['/road'], ['class' => 'list-group-item']);
            echo Html::a('Список паспортів доріг', ['/road-passport'], ['class' => 'list-group-item']);
            echo Html::a('Редагування маршрутів (карта)', ['/map'], ['class' => 'list-group-item']);
        ?>
    </div>
</div>
