<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\SettlementAddressLink */

$this->title = $model->settlement_address_link_id;
$this->params['breadcrumbs'][] = ['label' => 'Settlement Address Links', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="settlement-address-link-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->settlement_address_link_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->settlement_address_link_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'settlement_address_link_id',
            'road_id',
            'region_id',
            'begin',
            'end',
            'settlement_location_id',
            'settlement_id',
            'distance',
        ],
    ]) ?>

</div>
