<?php

    use common\models\SettlementAddressLink;
    use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\SettlementAddressLinkSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Адресна прив\'язка доріг';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="settlement-address-link-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Створити відомість', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => null,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'road_id',
                'value' => function($model) {
                    return $model->road->name;
                }
            ],
            [
                'attribute' => 'region_id',
                'value' => function($model) {
                    return $model->region->name;
                }
            ],
            [
                'attribute' => 'begin',
                'value' => function($model) {
                    /**
                     * @var SettlementAddressLink $model
                     */
                    return $model->getBeginString();
                }
            ],
            [
                'attribute' => 'end',
                'value' => function($model) {
                    /**
                     * @var SettlementAddressLink $model
                     */
                    return $model->getEndString();
                }
            ],
            [
                'attribute' => 'settlement_id',
                'value' => function($model) {
                    /**
                     * @var SettlementAddressLink $model
                     */
                    return $model->settlement->sign;
                }
            ],
            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
