<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\ServiceObject */

$this->title = $model->service_object_id;
$this->params['breadcrumbs'][] = ['label' => 'Service Objects', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="service-object-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->service_object_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->service_object_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'service_object_id',
            'road_id',
            'region_id',
            'service_object_type_id',
            'settlement_id',
            'department_affiliation_id',
            'location_right',
            'location_left',
            'location_axis',
            'distance',
            'capacity',
            'arrangement_elements:ntext',
        ],
    ]) ?>

</div>
