<?php

    use yii\helpers\Html;

    /**
     * @var yii\web\View                $this
     * @var common\models\ServiceObject $model
     * @var array                       $roads
     * @var array                       $regions
     * @var array                       $service_object_types
     * @var array                       $settlements
     * @var array                       $department_affiliations
     */

    $this->title = 'Create Service Object';
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Service Objects',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="service-object-create">

    <h1><?= Html::encode($this->title) ?></h1>

    <?= $this->render('_form', [
        'model'                   => $model,
        'roads'                   => $roads,
        'regions'                 => $regions,
        'service_object_types'    => $service_object_types,
        'settlements'             => $settlements,
        'department_affiliations' => $department_affiliations,
    ]) ?>

</div>
