<?php

    /**
     * @var Road     $road
     * @var Region[] $settlement_regions
     * @var Region[] $flow_intensity_regions
     * @var Region[] $cross_section_regions
     * @var Region[] $road_surface_regions
     * @var Region[] $service_object_regions
     * @var Region[] $bus_stop_regions
     * @var Region[] $road_to_categories
     * @var Region[] $road_width
     */

    use common\models\Region;
    use common\models\Road;
    use yii\bootstrap\Html;
    use yii\widgets\DetailView;

    $this->title = $road->name;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Дороги',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="site-index">
    <div class="col-xs-12">
        <?php
            echo DetailView::widget([
                'model'      => $road,
                'attributes' => [
                    'name',
                    [
                        'label' => 'Тип дороги',
                        'value' => $road->roadType->value . ' (' . $road->roadType->definition . ')',
                    ],
                    [
                        'label' => 'Позначення',
                        'value' => $road->roadType->value . '-' . str_pad($road->index, 2, '0', STR_PAD_LEFT),
                    ],
                ],
            ]);
        ?>
    </div>
    <div class="col-xs-12">
        <p class="text-center">Відомості:</p>
        <?php
        // Копируешь отсюда
        ?>
        <div class="panel panel-default">
            <div class="panel-heading">
                <a href="#settlements" data-toggle="collapse" aria-expanded="false" aria-controls="settlements">Адресна прив'язка населених пунктів</a>
            </div>
            <div class="panel-body collapse" id="settlements">
                <?php
                    if(!empty( $settlement_regions )) {
                        ?>
                        <div class="list-group">
                            <?php
                                foreach($settlement_regions as $region) {
                                    echo Html::a($region->name . ' область', [
                                        'settlement',
                                        'id'        => $road->road_id,
                                        'region_id' => $region->region_id,
                                    ]);
                                }
                            ?>
                        </div>
                        <?php
                    } else {
                        echo Html::tag('p', 'Населені пункти не знайдені.');
                    }
                ?>
            </div>
        </div>
        <?php
            // До сюда
        ?>
        <div class="panel panel-default">
            <div class="panel-heading">
                <a href="#flow_intensities" data-toggle="collapse" aria-expanded="false" aria-controls="flow_intensities">Інтенсивність руху та склад транспортного потоку</a>
            </div>
            <div class="panel-body collapse" id="flow_intensities">
                <?php
                    if(!empty( $flow_intensity_regions )) {
                        ?>
                        <div class="list-group">
                            <?php
                                foreach($flow_intensity_regions as $region) {
                                    echo Html::a($region->name . ' область', [
                                        'flow-intensity',
                                        'id'        => $road->road_id,
                                        'region_id' => $region->region_id,
                                    ]);
                                }
                            ?>
                        </div>
                        <?php
                    } else {
                        echo Html::tag('p', 'Відомості не знайдені.');
                    }
                ?>
            </div>
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <a href="#cross_sections" data-toggle="collapse" aria-expanded="false" aria-controls="cross_sections">Наявність та технічний стан з'їздів</a>
            </div>
            <div class="panel-body collapse" id="cross_sections">
                <?php
                    if(!empty( $cross_section_regions )) {
                        ?>
                        <div class="list-group">
                            <?php
                                foreach($cross_section_regions as $region) {
                                    echo Html::a($region->name . ' область', [
                                        'cross-section',
                                        'id'        => $road->road_id,
                                        'region_id' => $region->region_id,
                                    ]);
                                }
                            ?>
                        </div>
                        <?php
                    } else {
                        echo Html::tag('p', 'Відомості не знайдені.');
                    }
                ?>
            </div>
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <a href="#road_surfaces" data-toggle="collapse" aria-expanded="false" aria-controls="road_surfaces">Наявність та технічний стан покриття автодоріг</a>
            </div>
            <div class="panel-body collapse" id="road_surfaces">
                <?php
                    if(!empty( $road_surface_regions )) {
                        ?>
                        <div class="list-group">
                            <?php
                                foreach($road_surface_regions as $region) {
                                    echo Html::a($region->name . ' область', [
                                        'road-surface',
                                        'id'        => $road->road_id,
                                        'region_id' => $region->region_id,
                                    ]);
                                }
                            ?>
                        </div>
                        <?php
                    } else {
                        echo Html::tag('p', 'Відомості не знайдені.');
                    }
                ?>
            </div>
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <a href="#service_objects" data-toggle="collapse" aria-expanded="false" aria-controls="service_objects">Наявність споруд автослужб, об'єктів сервісу</a>
            </div>
            <div class="panel-body collapse" id="service_objects">
                <?php
                    if(!empty( $service_object_regions )) {
                        ?>
                        <div class="list-group">
                            <?php
                                foreach($service_object_regions as $region) {
                                    echo Html::a($region->name . ' область', [
                                        'service-object',
                                        'id'        => $road->road_id,
                                        'region_id' => $region->region_id,
                                    ]);
                                }
                            ?>
                        </div>
                        <?php
                    } else {
                        echo Html::tag('p', 'Відомості не знайдені.');
                    }
                ?>
            </div>
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <a href="#bus_stops" data-toggle="collapse" aria-expanded="false" aria-controls="bus_stops">Наявності та технічного стану автобусних зупинок</a>
            </div>
            <div class="panel-body collapse" id="bus_stops">
                <?php
                    if(!empty( $bus_stop_regions )) {
                        ?>
                        <div class="list-group">
                            <?php
                                foreach($bus_stop_regions as $region) {
                                    echo Html::a($region->name . ' область', [
                                        'bus-stop',
                                        'id'        => $road->road_id,
                                        'region_id' => $region->region_id,
                                    ]);
                                }
                            ?>
                        </div>
                        <?php
                    } else {
                        echo Html::tag('p', 'Відомості не знайдені.');
                    }
                ?>
            </div>
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <a href="#road_to_categories" data-toggle="collapse" aria-expanded="false" aria-controls="road_to_categories">Категорії доріг</a>
            </div>
            <div class="panel-body collapse" id="road_to_categories">
                <?php
                if(!empty( $road_to_categories )) {
                    ?>
                    <div class="list-group">
                        <?php
                        foreach($road_to_categories as $region) {
                            echo Html::a($region->name . ' область', [
                                'road-to-category',
                                'id'        => $road->road_id,
                                'region_id' => $region->region_id,
                            ]);
                        }
                        ?>
                    </div>
                <?php
                } else {
                    echo Html::tag('p', 'Населені пункти не знайдені.');
                }
                ?>
            </div>
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <a href="#road_width" data-toggle="collapse" aria-expanded="false" aria-controls="road_width">Ширина проїзної частини та земляного полотна</a>
            </div>
            <div class="panel-body collapse" id="road_width">
                <?php
                if(!empty( $road_width )) {
                    ?>
                    <div class="list-group">
                        <?php
                        foreach($road_width as $region) {
                            echo Html::a($region->name . ' область', [
                                'road-width',
                                'id'        => $road->road_id,
                                'region_id' => $region->region_id,
                            ]);
                        }
                        ?>
                    </div>
                <?php
                } else {
                    echo Html::tag('p', 'Населені пункти не знайдені.');
                }
                ?>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
</div>
