<?php

    /**
     * @var Road               $road
     * @var Region             $region
     * @var ActiveDataProvider $dataProvider
     */

    use common\models\BusStop;
    use common\models\Region;
    use common\models\Road;
    use common\models\RoadSurface;
    use yii\data\ActiveDataProvider;
    use yii\grid\GridView;

    $this->title = $road->name;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Дороги',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $this->title,
        'url'   => [
            'view',
            'id' => $road->road_id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = 'Відомість наявності та технічного стану автобусних зупинок - ' . ucfirst($region->name). ' область';
?>
<div class="site-index">
    <div class="col-xs-6 text-center">
        Міністрество транспорту України <br>
        Державна служба автомобільних доріг <br>
        України
    </div>
    <div class="col-xs-6 text-center">
        Служба автомобільних доріг у <?php echo $region->name; ?> області
    </div>
    <div class="clearfix"></div>
    <div class="col-xs-12 text-center">
        <p class="h3">Відомість</p>
        <p>наявності та технічного стану</p>
        <p><b>автобусних зупинок</b></p>
        <p>на автомобільній дорозі</p>
        <p><ins><?php echo $road->name; ?></ins></p>
        <p><ins><?php echo $road->roadType->definition;?></ins> значення станом на <ins><?php echo date('d F Y');?> р.</ins></p>
    </div>
    <div class="col-xs-12 text-center">
        <?php
        echo GridView::widget([
            'dataProvider' => $dataProvider,
            'layout' => "{items}",
            'columns' => [
                [
                    'attribute' => 'location_right',
                    'value' => function($model) {
                        /**
                         * @var BusStop $model
                         */
                        return $model->getRightString();
                    }
                ],
                [
                    'attribute' => 'location_left',
                    'value' => function($model) {
                        /**
                         * @var BusStop $model
                         */
                        return $model->getLeftString();
                    }
                ],
                [
                    'attribute' => 'settlement_id',
                    'value' => function($model) {
                        /**
                         * @var BusStop $model
                         */
                        return $model->settlement->name;
                    }
                ],
                [
                    'attribute' => 'surface_type_id',
                    'value' => function($model) {
                        /**
                         * @var BusStop $model
                         */
                        return $model->surfaceType->name;
                    }
                ],
                'area_stop_availability',
                'area_land_availability',
                'pocket_availability',
                'toilet_availability',
                'year_build',
                'year_repair',
                [
                    'attribute' => 'state_common_id',
                    'value' => function($model) {
                        /**
                         * @var BusStop $model
                         */
                        return $model->stateCommon->value;
                    }
                ],
            ],
        ]);
        ?>
    </div>
</div>
