<?php

    use common\models\RoadWidth;
    use yii\helpers\Html;
    use yii\grid\GridView;

    /* @var $this yii\web\View */
    /* @var $searchModel common\models\RoadWidthSearch */
    /* @var $dataProvider yii\data\ActiveDataProvider */

    $this->title = 'Ширина проїзної частини';
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="road-width-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Road Width', [ 'create' ], [ 'class' => 'btn btn-success' ]) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel'  => $searchModel,
        'columns'      => [
            [ 'class' => 'yii\grid\SerialColumn' ],
            [
                'attribute' => 'region_id',
                'value'     => function($model) {
                    /**
                     * @var RoadWidth $model
                     */
                    return $model->region->name;
                },
            ],
            [
                'attribute' => 'road_id',
                'value'     => function($model) {
                    /**
                     * @var RoadWidth $model
                     */
                    return $model->road->name;
                },
            ],
            [
                'attribute' => 'begin',
                'value'     => function($model) {
                    /**
                     * @var RoadWidth $model
                     */
                    return $model->getBeginString();
                },
            ],
            [
                'attribute' => 'end',
                'value'     => function($model) {
                    /**
                     * @var RoadWidth $model
                     */
                    return $model->getEndString();
                },
            ],

            [ 'class' => 'yii\grid\ActionColumn' ],
        ],
    ]); ?>
</div>
