<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/*
 * @var yii\web\View $this
 * @var common\models\RoadWidth $model
 * @var yii\widgets\ActiveForm $form
 * @var array $regions
 * @var array $roads
 */
?>

<div class="road-width-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'region_id')->dropDownList($regions) ?>

    <?= $form->field($model, 'road_id')->dropDownList($roads) ?>

    <?= $form->field($model, 'begin')->textInput() ?>

    <?= $form->field($model, 'end')->textInput() ?>

    <?= $form->field($model, 'width_roadside_left')->textInput() ?>

    <?= $form->field($model, 'width_reverse_road')->textInput() ?>

    <?= $form->field($model, 'width_strip')->textInput() ?>

    <?= $form->field($model, 'width_roadway_forward')->textInput() ?>

    <?= $form->field($model, 'width_roadside_right')->textInput() ?>

    <?= $form->field($model, 'count_lane_left')->textInput() ?>

    <?= $form->field($model, 'count_lane_right')->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
