<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\RoadSurface */

$this->title = $model->road_surface_id;
$this->params['breadcrumbs'][] = ['label' => 'Road Surfaces', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="road-surface-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->road_surface_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->road_surface_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'road_surface_id',
            'road_id',
            'region_id',
            'road_direction_id',
            'begin',
            'end',
            'surface_type_id',
            'surface_treatment_id',
            'state_common_id',
        ],
    ]) ?>

</div>
