<?php

use yii\helpers\Html;

    /**
     * @var yii\web\View              $this
     * @var common\models\RoadSurface $model
     * @var array                     $roads
     * @var array                     $regions
     * @var array                     $road_directions
     * @var array                     $surface_types
     * @var array                     $surface_treatments
     * @var array                     $state_commons
     */

$this->title = 'Update Road Surface: ' . $model->road_surface_id;
$this->params['breadcrumbs'][] = ['label' => 'Road Surfaces', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->road_surface_id, 'url' => ['view', 'id' => $model->road_surface_id]];
$this->params['breadcrumbs'][] = 'Update';
?>
<div class="road-surface-update">

    <h1><?= Html::encode($this->title) ?></h1>

    <?= $this->render('_form', [
        'model'              => $model,
        'roads'              => $roads,
        'regions'            => $regions,
        'road_directions'    => $road_directions,
        'surface_types'      => $surface_types,
        'surface_treatments' => $surface_treatments,
        'state_commons'      => $state_commons,
    ]) ?>

</div>
