<?php

    use common\models\RoadSurface;
    use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\RoadSurfaceSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Покриття доріг';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="road-surface-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Road Surface', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => null,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'road_id',
                'value' => function($model) {
                    /**
                     * @var RoadSurface $model
                     */
                    return $model->road->name;
                }
            ],
            [
                'attribute' => 'region_id',
                'value' => function($model) {
                    /**
                     * @var RoadSurface $model
                     */
                    return $model->region->name;
                }
            ],
            [
                'attribute' => 'road_direction_id',
                'value' => function($model) {
                    /**
                     * @var RoadSurface $model
                     */
                    return $model->roadDirection->direction_name;
                }
            ],
            [
                'attribute' => 'begin',
                'value' => function($model) {
                    /**
                     * @var RoadSurface $model
                     */
                    return $model->getBeginString();
                }
            ],
            [
                'attribute' => 'end',
                'value' => function($model) {
                    /**
                     * @var RoadSurface $model
                     */
                    return $model->getEndString();
                }
            ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
