<?php

    use yii\helpers\Html;
    use yii\widgets\ActiveForm;

    /**
     * @var yii\web\View              $this
     * @var common\models\RoadSurface $model
     * @var array                     $roads
     * @var array                     $regions
     * @var array                     $road_directions
     * @var array                     $surface_types
     * @var array                     $surface_treatments
     * @var array                     $state_commons
     * @var yii\widgets\ActiveForm    $form
     */
?>

<div class="road-surface-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'road_id')
             ->dropDownList($roads) ?>

    <?= $form->field($model, 'region_id')
             ->dropDownList($regions) ?>

    <?= $form->field($model, 'road_direction_id')
             ->dropDownList($road_directions) ?>

    <?= $form->field($model, 'begin')
             ->textInput() ?>

    <?= $form->field($model, 'end')
             ->textInput() ?>

    <?= $form->field($model, 'surface_type_id')
             ->dropDownList($surface_types) ?>

    <?= $form->field($model, 'surface_treatment_id')
             ->dropDownList($surface_treatments) ?>

    <?= $form->field($model, 'state_common_id')
             ->dropDownList($state_commons) ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
