<?php
    
    use yii\helpers\Html;
    
    /**
     * @var yii\web\View              $this
     * @var common\models\RoadService $model
     * @var array                     $roads
     * @var array                     $organizations
     * @var array                     $regions
     * @var array                     $directions
     */
    
    $this->title = 'Оновити відомість обслуговування автомобільної дороги: ' . $model->road_service_id;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Обслуговування автодоріг',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $model->road_service_id,
        'url'   => [
            'view',
            'id' => $model->road_service_id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = 'Оновити';
?>
<div class="road-service-update">
    
    <h1><?= Html::encode($this->title) ?></h1>
    
    <?= $this->render('_form', [
        'model'         => $model,
        'roads'         => $roads,
        'organizations' => $organizations,
        'regions'       => $regions,
        'directions'    => $directions,
    ]) ?>

</div>
