<?php
    /**
     * @var View           $this
     * @var RoadPassport[] $passports
     */
    use common\models\RoadPassport;
    use frontend\assets\MapAsset;
    use yii\helpers\Url;
    use yii\web\View;
    
    $this->title = 'My Yii Application';
    $points_url = Url::to([ 'point/get' ]);
    $template_url = Url::to([ 'point/add' ]);
    $save_url = Url::to([ 'point/save' ]);
    $snap_url = Url::to([ 'point/snap' ]);
    $this->registerJs('var snap_url = "' . $snap_url . '"; var points_url = "' . $points_url . '"; var template_url = "' . $template_url . '"; var save_url = "' . $save_url . '";', $this::POS_HEAD);
    MapAsset::register($this);
?>
<div class="controls">
    <div class="text-center">
        <a href="#control_menu" aria-expanded="false" aria-controls="control_menu" data-toggle="collapse"><span class="glyphicon glyphicon-menu-hamburger"></span>Меню</a>
    </div>
    <div class="panel-group collapse" id="control_menu">
        <ul class="list-group">
            <li class="list-group-item road_passport_list">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <a href="#roadPassports" data-toggle="collapse" aria-expanded="false" aria-controls="roadPassports">Паспорти доріг</a>
                    </div>
                    <div class="panel-body collapse" id="roadPassports">
                        <?php
                            foreach($passports as $passport) {
                                ?>
                                <div class="road_passport_list_item">
                                    <div>
                                        <?php
                                            echo $passport->road->roadType->value . '-' . str_pad($passport->road->index, 2, '0', STR_PAD_LEFT) . ': ' . floor($passport->begin) . '+' . str_pad(( ( $passport->begin - floor($passport->begin) ) * 100 ), 3, '0', STR_PAD_LEFT) . ' - ' . floor($passport->end) . '+' . str_pad(( ( $passport->end - floor($passport->end) ) * 1000 ), 3, '0', STR_PAD_LEFT);
                                        ?>
                                    </div>
                                    <div class="text-right">
                                        <a href="#roadPassport<?php echo $passport->road_passport_id ?>" data-toggle="collapse" aria-expanded="false" aria-controls="roadPassport<?php echo $passport->road_passport_id ?>">Налаштування</a>
                                    </div>
                                    <div class="panel-footer collapse" id="roadPassport<?php echo $passport->road_passport_id ?>">
                                        <span class="glyphicon glyphicon-road edit_path" title="Додати/змінити шлях" data-passport-id="<?php echo $passport->road_passport_id; ?>"></span>
                                        <a href=""><span class="glyphicon glyphicon-pencil" title="Редагувати паспорт"></span></a>
                                    </div>
                                </div>
                                <?php
                            }
                        ?>
                    </div>
                </div>
            </li>
            <li class="list-group-item">
                <div class="panel panel-default">
                    <div class="panel-heading">Panel heading 2</div>
                    <div class="panel-body">Panel body 2</div>
                    <div class="panel-footer">Panel footer 2</div>
                </div>
            </li>
            <li class="list-group-item">
                <div class="panel panel-default">
                    <div class="panel-heading">Panel heading 3</div>
                    <div class="panel-body">Panel body 3</div>
                    <div class="panel-footer">Panel footer 3</div>
                </div>
            </li>
        </ul>
    </div>
</div>
<div class="site-index">
    <div class="col-xs-12 top_control">

    </div>
    <div class="col-xs-12">
        <div id="map">
        
        </div>
    </div>
    <div class="col-xs-12">
        <div>
            <p><button id="snap_me" class="btn btn-success">Привязать к дороге</button></p>
        </div>
        <div id="control"></div>
    </div>
    <div class="clearfix"></div>
</div>
