<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\FlowIntensity */

$this->title = $model->flow_intensity_id;
$this->params['breadcrumbs'][] = ['label' => 'Flow Intensities', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="flow-intensity-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->flow_intensity_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->flow_intensity_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'flow_intensity_id',
            'road_id',
            'region_id',
            'location',
            'begin',
            'end',
            'road_direction_id',
            'settlement_id',
            'intensity_total',
            'intensity_increase',
            'intensity_moto',
            'intensity_moto_sidecar',
            'intensity_car',
            'intensity_truck_two',
            'intensity_truck_two_six',
            'intensity_truck_six_eight',
            'intensity_truck_eight_fourteen',
            'intensity_truck_fourteen',
            'intensity_lorry_twelve',
            'intensity_lorry_twelve_twenty',
            'intensity_lorry_twenty_thirty',
            'intensity_lorry_thirty',
            'intensity_tractor_under_ten',
            'intensity_tractor_over_ten',
            'intensity_bus',
            'intensity_bus_coupled',
            'date_add',
        ],
    ]) ?>

</div>
