<?php

    use yii\helpers\Html;

    /**
     * @var yii\web\View $this
     * @var common\models\FlowIntensity $model
     * @var array $roads
     * @var array $road_directions
     * @var array $regions
     * @var array $settlements
     */

    $this->title = 'Update Flow Intensity: ' . $model->flow_intensity_id;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Flow Intensities',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $model->flow_intensity_id,
        'url'   => [
            'view',
            'id' => $model->flow_intensity_id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = 'Update';
?>
<div class="flow-intensity-update">

    <h1><?= Html::encode($this->title) ?></h1>

    <?= $this->render('_form', [
        'model' => $model,
        'roads'           => $roads,
        'regions'         => $regions,
        'road_directions' => $road_directions,
        'settlements'     => $settlements,
    ]) ?>

</div>
