<?php

    use common\models\FlowIntensity;
    use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\FlowIntensitySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Інтенсивність руху та склад транспортного потоку';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="flow-intensity-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Додати', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => null,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'road_id',
                'value' => function($model) {
                    /**
                     * @var FlowIntensity $model
                     */
                    return $model->road->name;
                }
            ],
            [
                'attribute' => 'region_id',
                'value' => function($model) {
                    /**
                     * @var FlowIntensity $model
                     */
                    return $model->region->name;
                }
            ],
            [
                'attribute' => 'location',
                'value' => function($model) {
                    /**
                     * @var FlowIntensity $model
                     */
                    return $model->getLocationString();
                }
            ],
            [
                'attribute' => 'road_direction_id',
                'value' => function($model) {
                    /**
                     * @var FlowIntensity $model
                     */
                    return $model->roadDirection->direction_name;
                }
            ],
            [
                'attribute' => 'settlement_id',
                'value' => function($model) {
                    /**
                     * @var FlowIntensity $model
                     */
                    return $model->settlement->sign;
                }
            ],
            [
                'attribute' => 'date_add',
                'value' => function($model) {
                    /**
                     * @var FlowIntensity $model
                     */
                    return date('d.m.Y', $model->date_add);
                }
            ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
