<?php

    use yii\helpers\Html;
    use yii\widgets\ActiveForm;

    /**
     * @var yii\web\View                $this
     * @var common\models\FlowIntensity $model
     * @var array                       $roads
     * @var array                       $road_directions
     * @var array                       $regions
     * @var array                       $settlements
     * @var yii\widgets\ActiveForm      $form
     */
?>

<div class="flow-intensity-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'road_id')
             ->dropDownList($roads) ?>

    <?= $form->field($model, 'region_id')
             ->dropDownList($regions) ?>

    <?= $form->field($model, 'location')
             ->textInput() ?>

    <?= $form->field($model, 'begin')
             ->textInput() ?>

    <?= $form->field($model, 'end')
             ->textInput() ?>

    <?= $form->field($model, 'road_direction_id')
             ->dropDownList($road_directions) ?>

    <?= $form->field($model, 'settlement_id')
             ->dropDownList($settlements) ?>

    <?= $form->field($model, 'intensity_total')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_increase')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_moto')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_moto_sidecar')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_car')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_truck_two')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_truck_two_six')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_truck_six_eight')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_truck_eight_fourteen')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_truck_fourteen')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_lorry_twelve')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_lorry_twelve_twenty')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_lorry_twenty_thirty')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_lorry_thirty')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_tractor_under_ten')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_tractor_over_ten')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_bus')
             ->textInput() ?>

    <?= $form->field($model, 'intensity_bus_coupled')
             ->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
