<?php

    use common\models\CrossSection;
    use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\CrossSectionSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Наявність та технічний стан з\'їздів';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="cross-section-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Cross Section', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'region_id',
                'value' => function($model) {
                    /**
                     * @var CrossSection $model
                     */
                    return $model->region->name;
                }
            ],
            [
                'attribute' => 'road_id',
                'value' => function($model) {
                    /**
                     * @var CrossSection $model
                     */
                    return $model->road->name;
                }
            ],
            'location_left',
            'location_right',
            'direction',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
