<?php

    use yii\helpers\Html;

    /**
     * @var yii\web\View          $this
     * @var array                 $roads
     * @var array                 $regions
     * @var array                 $settlements
     * @var array                 $surface_types
     * @var array                 $state_commons
     * @var common\models\BusStop $model
     */

    $this->title = 'Update Bus Stop: ' . $model->bus_stop_id;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => 'Bus Stops',
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $model->bus_stop_id,
        'url'   => [
            'view',
            'id' => $model->bus_stop_id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = 'Update';
?>
<div class="bus-stop-update">

    <h1><?= Html::encode($this->title) ?></h1>

    <?= $this->render('_form', [
        'model'         => $model,
        'roads'         => $roads,
        'regions'       => $regions,
        'settlements'   => $settlements,
        'surface_types' => $surface_types,
        'state_commons' => $state_commons,
    ]) ?>

</div>
