<?php

    use common\models\BusStop;
    use yii\helpers\Html;
    use yii\grid\GridView;

    /* @var $this yii\web\View */
    /* @var $searchModel common\models\BusStopSearch */
    /* @var $dataProvider yii\data\ActiveDataProvider */

    $this->title = 'Автобусні зупинки';
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="bus-stop-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Bus Stop', [ 'create' ], [ 'class' => 'btn btn-success' ]) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel'  => $searchModel,
        'columns'      => [
            [ 'class' => 'yii\grid\SerialColumn' ],
            [
                'attribute' => 'road_id',
                'value'     => function($model) {
                    /**
                     * @var BusStop $model
                     */
                    return $model->road->name;
                },
            ],
            [
                'attribute' => 'region_id',
                'value'     => function($model) {
                    /**
                     * @var BusStop $model
                     */
                    return $model->region->name;
                },
            ],
            [
                'attribute' => 'location_right',
                'value'     => function($model) {
                    /**
                     * @var BusStop $model
                     */
                    return $model->getRightString();
                },
            ],
            [
                'attribute' => 'location_left',
                'value'     => function($model) {
                    /**
                     * @var BusStop $model
                     */
                    return $model->getLeftString();
                },
            ],
            [
                'attribute' => 'state_common_id',
                'value'     => function($model) {
                    /**
                     * @var BusStop $model
                     */
                    return $model->stateCommon->value;
                },
            ],

            [ 'class' => 'yii\grid\ActionColumn' ],
        ],
    ]); ?>
</div>
