<?php

    use yii\helpers\Html;
    use yii\widgets\ActiveForm;

    /**
     * @var yii\web\View           $this
     * @var array                  $roads
     * @var array                  $regions
     * @var array                  $settlements
     * @var array                  $surface_types
     * @var array                  $state_commons
     * @var common\models\BusStop  $model
     * @var yii\widgets\ActiveForm $form
     */
?>

<div class="bus-stop-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'road_id')
             ->dropDownList($roads) ?>

    <?= $form->field($model, 'region_id')
             ->dropDownList($regions) ?>

    <?= $form->field($model, 'settlement_id')
             ->dropDownList($settlements) ?>

    <?= $form->field($model, 'location_right')
             ->textInput() ?>

    <?= $form->field($model, 'location_left')
             ->textInput() ?>

    <?= $form->field($model, 'surface_type_id')
             ->dropDownList($surface_types) ?>

    <?= $form->field($model, 'area_stop_availability')
             ->dropDownList([0 => 'Нет', 1 => 'Да']) ?>

    <?= $form->field($model, 'area_land_availability')
             ->dropDownList([0 => 'Нет', 1 => 'Да']) ?>

    <?= $form->field($model, 'pocket_availability')
             ->dropDownList([0 => 'Нет', 1 => 'Да']) ?>

    <?= $form->field($model, 'toilet_availability')
             ->dropDownList([0 => 'Нет', 1 => 'Да']) ?>

    <?= $form->field($model, 'year_build')
             ->textInput() ?>

    <?= $form->field($model, 'year_repair')
             ->textInput() ?>

    <?= $form->field($model, 'state_common_id')
             ->dropDownList($state_commons) ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
