<?php
    namespace frontend\controllers;
    
    use common\models\RoadPassport;
    use yii\data\ActiveDataProvider;
    use yii\web\Controller;

    class StatementController extends Controller
    {
        /**
         * @inheritdoc
         */
        public function actions()
        {
            return [
                'error' => [
                    'class' => 'yii\web\ErrorAction',
                ],
            ];
        }

        /**
         * @return mixed
         */
        public function actionIndex()
        {
            $passports_query = RoadPassport::find()->with('road')->with('road.roadType');
            $dataProvider = new ActiveDataProvider([
                'query' => $passports_query,
                'pagination' => [
                    'pageSize' => 20,
                ],
            ]);
            return $this->render('index', ['dataProvider' => $dataProvider]);
        }

    }
