<?php

    namespace frontend\controllers;

    use common\models\Region;
    use common\models\Road;
    use common\models\Settlement;
    use common\models\SettlementLocation;
    use Yii;
    use common\models\SettlementAddressLink;
    use common\models\SettlementAddressLinkSearch;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use yii\filters\VerbFilter;

    /**
     * SettlementAddressLinkController implements the CRUD actions for SettlementAddressLink model.
     */
    class SettlementAddressLinkController extends Controller
    {

        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'verbs' => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'POST' ],
                    ],
                ],
            ];
        }

        /**
         * Lists all SettlementAddressLink models.
         * @return mixed
         */
        public function actionIndex()
        {
            $searchModel = new SettlementAddressLinkSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

            return $this->render('index', [
                'searchModel'  => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }

        /**
         * Displays a single SettlementAddressLink model.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionView($id)
        {
            return $this->render('view', [
                'model' => $this->findModel($id),
            ]);
        }

        /**
         * Creates a new SettlementAddressLink model.
         * If creation is successful, the browser will be redirected to the 'view' page.
         * @return mixed
         */
        public function actionCreate()
        {
            $model = new SettlementAddressLink();

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();

            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();

            $settlement_locations = SettlementLocation::find()
                                                      ->select([
                                                          'value',
                                                          'settlement_location_id',
                                                      ])
                                                      ->asArray()
                                                      ->indexBy('settlement_location_id')
                                                      ->column();

            $settlements = Settlement::find()
                                     ->select([
                                         'sign',
                                         'settlement_id',
                                     ])
                                     ->asArray()
                                     ->indexBy('settlement_id')
                                     ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->settlement_address_link_id,
                ]);
            } else {
                return $this->render('create', [
                    'model'                => $model,
                    'roads'                => $roads,
                    'regions'              => $regions,
                    'settlement_locations' => $settlement_locations,
                    'settlements'          => $settlements,
                ]);
            }
        }

        /**
         * Updates an existing SettlementAddressLink model.
         * If update is successful, the browser will be redirected to the 'view' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionUpdate($id)
        {
            $model = $this->findModel($id);

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();

            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();

            $settlement_locations = SettlementLocation::find()
                                                      ->select([
                                                          'value',
                                                          'settlement_location_id',
                                                      ])
                                                      ->asArray()
                                                      ->indexBy('settlement_location_id')
                                                      ->column();

            $settlements = Settlement::find()
                                     ->select([
                                         'sign',
                                         'settlement_id',
                                     ])
                                     ->asArray()
                                     ->indexBy('settlement_id')
                                     ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->settlement_address_link_id,
                ]);
            } else {
                return $this->render('update', [
                    'model'                => $model,
                    'roads'                => $roads,
                    'regions'              => $regions,
                    'settlement_locations' => $settlement_locations,
                    'settlements'          => $settlements,
                ]);
            }
        }

        /**
         * Deletes an existing SettlementAddressLink model.
         * If deletion is successful, the browser will be redirected to the 'index' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionDelete($id)
        {
            $this->findModel($id)
                 ->delete();

            return $this->redirect([ 'index' ]);
        }

        /**
         * Finds the SettlementAddressLink model based on its primary key value.
         * If the model is not found, a 404 HTTP exception will be thrown.
         *
         * @param integer $id
         *
         * @return SettlementAddressLink the loaded model
         * @throws NotFoundHttpException if the model cannot be found
         */
        protected function findModel($id)
        {
            if(( $model = SettlementAddressLink::findOne($id) ) !== NULL) {
                return $model;
            } else {
                throw new NotFoundHttpException('The requested page does not exist.');
            }
        }
    }
