<?php

namespace frontend\controllers;

use common\models\Region;
use common\models\Road;
use common\models\RoadCategory;
use Yii;
use common\models\RoadToCategory;
use common\models\RoadToCategorySearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * RoadToCategoryController implements the CRUD actions for RoadToCategory model.
 */
class RoadToCategoryController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all RoadToCategory models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RoadToCategorySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single RoadToCategory model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new RoadToCategory model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new RoadToCategory();
        $regions = Region::find()
            ->select([
                'name',
                'region_id',
            ])
            ->indexBy('region_id')
            ->asArray()
            ->column();
        $roads = Road::find()
            ->select([
                'name',
                'road_id',
            ])
            ->indexBy('road_id')
            ->asArray()
            ->column();
        $road_categories = RoadCategory::find()
            ->select([
                'value',
                'road_category_id',
            ])
            ->indexBy('road_id')
            ->asArray()
            ->column();
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->road_to_category_id]);
        } else {
            return $this->render('create', [
                'model' => $model,
                'regions' => $regions,
                'roads' => $roads,
                'road_categories' => $road_categories,
            ]);
        }
    }

    /**
     * Updates an existing RoadToCategory model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $regions = Region::find()
            ->select([
                'name',
                'region_id',
            ])
            ->indexBy('region_id')
            ->asArray()
            ->column();
        $roads = Road::find()
            ->select([
                'name',
                'road_id',
            ])
            ->indexBy('road_id')
            ->asArray()
            ->column();
        $road_categories = RoadCategory::find()
            ->select([
                'value',
                'road_category_id',
            ])
            ->indexBy('road_id')
            ->asArray()
            ->column();
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->road_to_category_id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'regions' => $regions,
                'roads' => $roads,
                'road_categories' => $road_categories,
            ]);
        }
    }

    /**
     * Deletes an existing RoadToCategory model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the RoadToCategory model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return RoadToCategory the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = RoadToCategory::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
