<?php

    namespace frontend\controllers;

    use common\models\Region;
    use common\models\Road;
    use common\models\RoadDirection;
    use common\models\StateCommon;
    use common\models\SurfaceTreatment;
    use common\models\SurfaceType;
    use Yii;
    use common\models\RoadSurface;
    use common\models\RoadSurfaceSearch;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use yii\filters\VerbFilter;

    /**
     * RoadSurfaceController implements the CRUD actions for RoadSurface model.
     */
    class RoadSurfaceController extends Controller
    {

        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'verbs' => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'POST' ],
                    ],
                ],
            ];
        }

        /**
         * Lists all RoadSurface models.
         * @return mixed
         */
        public function actionIndex()
        {
            $searchModel = new RoadSurfaceSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

            return $this->render('index', [
                'searchModel'  => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }

        /**
         * Displays a single RoadSurface model.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionView($id)
        {
            return $this->render('view', [
                'model' => $this->findModel($id),
            ]);
        }

        /**
         * Creates a new RoadSurface model.
         * If creation is successful, the browser will be redirected to the 'view' page.
         * @return mixed
         */
        public function actionCreate()
        {
            $model = new RoadSurface();

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();

            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();

            $road_directions = RoadDirection::find()
                                            ->select([
                                                'direction_name',
                                                'road_direction_id',
                                            ])
                                            ->asArray()
                                            ->indexBy('road_direction_id')
                                            ->column();

            $surface_types = SurfaceType::find()
                                        ->select([
                                            'name',
                                            'surface_type_id',
                                        ])
                                        ->asArray()
                                        ->indexBy('surface_type_id')
                                        ->column();

            $surface_treatments = SurfaceTreatment::find()
                                                  ->select([
                                                      'name',
                                                      'surface_treatment_id',
                                                  ])
                                                  ->asArray()
                                                  ->indexBy('surface_treatment_id')
                                                  ->column();

            $state_commons = StateCommon::find()
                                        ->select([
                                            'value',
                                            'state_common_id',
                                        ])
                                        ->asArray()
                                        ->indexBy('state_common_id')
                                        ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->road_surface_id,
                ]);
            } else {
                return $this->render('create', [
                    'model'              => $model,
                    'roads'              => $roads,
                    'regions'            => $regions,
                    'road_directions'    => $road_directions,
                    'surface_types'      => $surface_types,
                    'surface_treatments' => $surface_treatments,
                    'state_commons'      => $state_commons,
                ]);
            }
        }

        /**
         * Updates an existing RoadSurface model.
         * If update is successful, the browser will be redirected to the 'view' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionUpdate($id)
        {
            $model = $this->findModel($id);

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();

            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();

            $road_directions = RoadDirection::find()
                                            ->select([
                                                'direction_name',
                                                'road_direction_id',
                                            ])
                                            ->asArray()
                                            ->indexBy('road_direction_id')
                                            ->column();

            $surface_types = SurfaceType::find()
                                        ->select([
                                            'name',
                                            'surface_type_id',
                                        ])
                                        ->asArray()
                                        ->indexBy('surface_type_id')
                                        ->column();

            $surface_treatments = SurfaceTreatment::find()
                                                  ->select([
                                                      'name',
                                                      'surface_treatment_id',
                                                  ])
                                                  ->asArray()
                                                  ->indexBy('surface_treatment_id')
                                                  ->column();

            $state_commons = StateCommon::find()
                                        ->select([
                                            'value',
                                            'state_common_id',
                                        ])
                                        ->asArray()
                                        ->indexBy('state_common_id')
                                        ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->road_surface_id,
                ]);
            } else {
                return $this->render('update', [
                    'model'              => $model,
                    'roads'              => $roads,
                    'regions'            => $regions,
                    'road_directions'    => $road_directions,
                    'surface_types'      => $surface_types,
                    'surface_treatments' => $surface_treatments,
                    'state_commons'      => $state_commons,
                ]);
            }
        }

        /**
         * Deletes an existing RoadSurface model.
         * If deletion is successful, the browser will be redirected to the 'index' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionDelete($id)
        {
            $this->findModel($id)
                 ->delete();

            return $this->redirect([ 'index' ]);
        }

        /**
         * Finds the RoadSurface model based on its primary key value.
         * If the model is not found, a 404 HTTP exception will be thrown.
         *
         * @param integer $id
         *
         * @return RoadSurface the loaded model
         * @throws NotFoundHttpException if the model cannot be found
         */
        protected function findModel($id)
        {
            if(( $model = RoadSurface::findOne($id) ) !== NULL) {
                return $model;
            } else {
                throw new NotFoundHttpException('The requested page does not exist.');
            }
        }
    }
