<?php
    namespace frontend\controllers;

    use common\models\BusStop;
    use common\models\CrossSection;
    use common\models\FlowIntensity;
    use common\models\Region;
    use common\models\Road;
    use common\models\RoadCategory;
    use common\models\RoadSurface;
    use common\models\RoadToCategory;
    use common\models\RoadType;
    use common\models\RoadWidth;
    use common\models\ServiceObject;
    use common\models\SettlementAddressLink;
    use yii\data\ActiveDataProvider;
    use yii\filters\VerbFilter;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;

    class RoadController extends Controller
    {

        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'verbs' => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'post' ],
                    ],
                ],
            ];
        }

        /**
         * @inheritdoc
         */
        public function actions()
        {
            return [
                'error' => [
                    'class' => 'yii\web\ErrorAction',
                ],
            ];
        }

        /**
         * @return mixed
         */
        public function actionCreate()
        {
            $road = new Road();
            $post = \Yii::$app->request->post();
            if($road->load($post) && $road->save()) {
                return $this->redirect([ 'index' ]);
            } else {
                $road_types = RoadType::find()
                                      ->select('value')
                                      ->indexBy('road_type_id')
                                      ->asArray()
                                      ->column();
                return $this->render('create', [
                    'road'            => $road,
                    'road_types'      => $road_types,
                ]);
            }
        }

        /**
         * @param int $id
         *
         * @return mixed
         * @throws NotFoundHttpException
         */
        public function actionDelete(int $id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $road->delete();
            return $this->redirect([ 'index' ]);
        }

        /**
         * @return mixed
         */
        public function actionIndex()
        {
            $query = Road::find()
                         ->with('roadType');
            $dataProvider = new ActiveDataProvider([
                'query'      => $query,
                'pagination' => [
                    'pageSize' => 20,
                ],
            ]);
            return $this->render('index', [ 'dataProvider' => $dataProvider ]);
        }

        /**
         * @param int $id
         *
         * @return mixed
         * @throws NotFoundHttpException
         */
        public function actionUpdate(int $id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $post = \Yii::$app->request->post();
            if($road->load($post) && $road->save()) {
                return $this->redirect([ 'index' ]);
            } else {
                $road_types = RoadType::find()
                                      ->select('value')
                                      ->indexBy('road_type_id')
                                      ->asArray()
                                      ->column();
                return $this->render('update', [
                    'road'            => $road,
                    'road_types'      => $road_types,
                ]);
            }
        }

        public function actionView(int $id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            // Копируешь отсюда
            $settlement_regions = [ ];
            $region_ids = [ ];
            $region_ids = SettlementAddressLink::find()
                                               ->distinct()
                                               ->select('region_id')
                                               ->where([ 'road_id' => $id ])
                                               ->column();
            if(!empty( $region_ids )) {
                $settlement_regions = Region::find()
                                            ->where([ 'region_id' => $region_ids ])
                                            ->all();
            }
            // До сюда заменяешь название своей моделью
            $flow_intensity_regions = [ ];
            $region_ids = [ ];
            $region_ids = FlowIntensity::find()
                                       ->distinct()
                                       ->select('region_id')
                                       ->where([ 'road_id' => $id ])
                                       ->column();
            if(!empty( $region_ids )) {
                $flow_intensity_regions = Region::find()
                                                ->where([ 'region_id' => $region_ids ])
                                                ->all();
            }
            $cross_section_regions = [ ];
            $region_ids = [ ];
            $region_ids = CrossSection::find()
                                      ->distinct()
                                      ->select('region_id')
                                      ->where([ 'road_id' => $id ])
                                      ->column();

            if(!empty( $region_ids )) {
                $cross_section_regions = Region::find()
                                               ->where([ 'region_id' => $region_ids ])
                                               ->all();
            }
            $road_surface_regions = [ ];
            $region_ids = [ ];
            $region_ids = RoadSurface::find()
                                     ->distinct()
                                     ->select('region_id')
                                     ->where([ 'road_id' => $id ])
                                     ->column();
            if(!empty( $region_ids )) {
                $road_surface_regions = Region::find()
                                              ->where([ 'region_id' => $region_ids ])
                                              ->all();
            }
            $service_object_regions = [ ];
            $region_ids = [ ];
            $region_ids = ServiceObject::find()
                                       ->distinct()
                                       ->select('region_id')
                                       ->where([ 'road_id' => $id ])
                                       ->column();
            if(!empty( $region_ids )) {
                $service_object_regions = Region::find()
                                                ->where([ 'region_id' => $region_ids ])
                                                ->all();
            }
            $bus_stop_regions = [ ];
            $region_ids = [ ];
            $region_ids = BusStop::find()
                                 ->distinct()
                                 ->select('region_id')
                                 ->where([ 'road_id' => $id ])
                                 ->column();
            if(!empty( $region_ids )) {
                $bus_stop_regions = Region::find()
                                          ->where([ 'region_id' => $region_ids ])
                                          ->all();
            }
            $road_to_categories = [ ];
            $region_ids = [ ];
            $region_ids = RoadToCategory::find()
                ->distinct()
                ->select('region_id')
                ->where([ 'road_id' => $id ])
                ->column();
            if(!empty( $region_ids )) {
                $road_to_categories = Region::find()
                    ->where([ 'region_id' => $region_ids ])
                    ->all();
            }
            $road_width = [ ];
            $region_ids = [ ];
            $region_ids = RoadWidth::find()
                ->distinct()
                ->select('region_id')
                ->where([ 'road_id' => $id ])
                ->column();
            if(!empty( $region_ids )) {
                $road_width = Region::find()
                    ->where([ 'region_id' => $region_ids ])
                    ->all();
            }
            return $this->render('view', [
                'road'                   => $road,
                'settlement_regions'     => $settlement_regions,
                'flow_intensity_regions' => $flow_intensity_regions,
                'cross_section_regions'  => $cross_section_regions,
                'road_to_categories'     => $road_to_categories,
                'road_width'             => $road_width,
                'road_surface_regions'   => $road_surface_regions,
                'service_object_regions' => $service_object_regions,
                'bus_stop_regions'       => $bus_stop_regions,
            ]);
        }

        public function actionSettlement(int $id, int $region_id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $region = Region::findOne($region_id);
            if(empty( $region )) {
                throw new NotFoundHttpException('Region not found');
            }
            $dataProvider = new ActiveDataProvider([
                'query'      => SettlementAddressLink::find()
                                                     ->where([
                                                         'road_id'   => $id,
                                                         'region_id' => $region_id,
                                                     ]),
                'pagination' => false,
            ]);
            return $this->render('settlement', [
                'road'         => $road,
                'region'       => $region,
                'dataProvider' => $dataProvider,
            ]);
        }

        public function actionRoadToCategory(int $id, int $region_id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $region = Region::findOne($region_id);
            if(empty( $region )) {
                throw new NotFoundHttpException('Region not found');
            }
            $dataProvider = new ActiveDataProvider([
                'query'      => RoadToCategory::find()
                    ->where([
                        'road_id'   => $id,
                        'region_id' => $region_id,
                    ]),
                'pagination' => false,
            ]);
            return $this->render('road-to-category', [
                'road'         => $road,
                'region'       => $region,
                'dataProvider' => $dataProvider,
            ]);
        }

        public function actionRoadWidth(int $id, int $region_id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $region = Region::findOne($region_id);
            if(empty( $region )) {
                throw new NotFoundHttpException('Region not found');
            }
            $dataProvider = new ActiveDataProvider([
                'query'      => RoadWidth::find()
                    ->where([
                        'road_id'   => $id,
                        'region_id' => $region_id,
                    ]),
                'pagination' => false,
            ]);
            return $this->render('road-width', [
                'road'         => $road,
                'region'       => $region,
                'dataProvider' => $dataProvider,
            ]);
        }
        public function actionFlowIntensity(int $id, int $region_id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $region = Region::findOne($region_id);
            if(empty( $region )) {
                throw new NotFoundHttpException('Region not found');
            }
            $dataProvider = new ActiveDataProvider([
                'query'      => FlowIntensity::find()
                                             ->where([
                                                 'road_id'   => $id,
                                                 'region_id' => $region_id,
                                             ]),
                'pagination' => false,
            ]);
            return $this->render('flow-intensity', [
                'road'         => $road,
                'region'       => $region,
                'dataProvider' => $dataProvider,
            ]);
        }

        public function actionCrossSection(int $id, int $region_id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $region = Region::findOne($region_id);
            if(empty( $region )) {
                throw new NotFoundHttpException('Region not found');
            }
            $dataProvider = new ActiveDataProvider([
                'query'      => CrossSection::find()
                                            ->where([
                                                'road_id'   => $id,
                                                'region_id' => $region_id,
                                            ]),
                'pagination' => false,
            ]);
            return $this->render('cross-section', [
                'road'         => $road,
                'region'       => $region,
                'dataProvider' => $dataProvider,
            ]);
        }

        public function actionRoadSurface(int $id, int $region_id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $region = Region::findOne($region_id);
            if(empty( $region )) {
                throw new NotFoundHttpException('Region not found');
            }
            $dataProvider = new ActiveDataProvider([
                'query'      => RoadSurface::find()
                                           ->where([
                                               'road_id'   => $id,
                                               'region_id' => $region_id,
                                           ]),
                'pagination' => false,
            ]);
            return $this->render('road-surface', [
                'road'         => $road,
                'region'       => $region,
                'dataProvider' => $dataProvider,
            ]);
        }

        public function actionServiceObject(int $id, int $region_id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $region = Region::findOne($region_id);
            if(empty( $region )) {
                throw new NotFoundHttpException('Region not found');
            }
            $dataProvider = new ActiveDataProvider([
                'query'      => ServiceObject::find()
                                             ->where([
                                                 'road_id'   => $id,
                                                 'region_id' => $region_id,
                                             ]),
                'pagination' => false,
            ]);
            return $this->render('service-object', [
                'road'         => $road,
                'region'       => $region,
                'dataProvider' => $dataProvider,
            ]);
        }

        public function actionBusStop(int $id, int $region_id)
        {
            $road = Road::findOne($id);
            if(empty( $road )) {
                throw new NotFoundHttpException('Road not found');
            }
            $region = Region::findOne($region_id);
            if(empty( $region )) {
                throw new NotFoundHttpException('Region not found');
            }
            $dataProvider = new ActiveDataProvider([
                'query'      => BusStop::find()
                                       ->where([
                                           'road_id'   => $id,
                                           'region_id' => $region_id,
                                       ]),
                'pagination' => false,
            ]);
            return $this->render('bus-stop', [
                'road'         => $road,
                'region'       => $region,
                'dataProvider' => $dataProvider,
            ]);
        }
    }
