<?php
    namespace frontend\controllers;

    use common\models\GoogleRoad;
    use common\models\Point;
    use common\models\RoadPassport;
    use yii\data\ActiveDataProvider;
    use yii\data\ArrayDataProvider;
    use yii\web\Controller;

    class PointController extends Controller
    {

        /**
         * @inheritdoc
         */
        public function actions()
        {
            return [
                'error' => [
                    'class' => 'yii\web\ErrorAction',
                ],
            ];
        }

        /**
         * @return mixed
         */
        public function actionGet($id)
        {
            $request = \Yii::$app->request;
            $response = \Yii::$app->response;
            $response->format = $response::FORMAT_JSON;
            $id = (int) $id;
            $road_passport = RoadPassport::findOne($id);
            if(empty( $road_passport )) {
                $response->setStatusCode(404);
                return $response->statusText;
            }
            $query = Point::find()
                          ->where([ 'road_passport_id' => (int) $id ])
                          ->orderBy('num')
                          ->indexBy('num');
            $dataProvider = new ActiveDataProvider([
                'query'      => $query,
                'key'        => 'num',
                'pagination' => [
                    'pageSize' => false,
                ],
            ]);
            return [
                'result' => [
                    'html'     => $this->renderAjax('list', [
                        'dataProvider'  => $dataProvider,
                        'passport_id'   => $id,
                        'road_passport' => $road_passport,
                    ]),
                    'points'   => $dataProvider->getModels(),
                    'passport' => $road_passport,
                ],
            ];
        }

        public function actionAdd($road_passport_id, $lat, $lng, $num, $km)
        {
            $request = \Yii::$app->request;
            $response = \Yii::$app->response;
            $response->format = $response::FORMAT_JSON;
            $get = $request->get();
            $road_passport = RoadPassport::findOne($road_passport_id);
            if(empty( $road_passport )) {
                $response->setStatusCode(404);
                return $response->statusText;
            }
            $point = new Point([
                'road_passport_id' => $road_passport_id,
                'lat'              => $lat,
                'lng'              => $lng,
                'num'              => $num,
                'km'               => $km,
            ]);
            return [
                'result' => [
                    'html' => $this->renderAjax('row', [
                        'point'       => $point,
                        'passport_id' => $road_passport_id,
                    ]),
                ],
            ];
        }

        public function actionSave()
        {
            $request = \Yii::$app->request;
            $response = \Yii::$app->response;
            $response->format = $response::FORMAT_JSON;
            $post = $request->post();
            if(!empty( $post )) {
                if(!empty( $post[ 'RoadPassport' ][ 'road_passport_id' ] )) {
                    $road_passport = RoadPassport::findOne($post[ 'RoadPassport' ][ 'road_passport_id' ]);
                    if(empty( $road_passport )) {
                        $response->setStatusCode(404);
                        return $response->statusText;
                    } else {
                        $points = [ ];
                        for($i = 1; $i <= count($post[ 'Point' ]); $i++) {
                            $points[ $i ] = new Point([ 'road_passport_id' => $road_passport->road_passport_id ]);
                        }
                        if(Point::loadMultiple($points, $post) && Point::validateMultiple($points)) {
                            Point::deleteAll([ 'road_passport_id' => $road_passport->road_passport_id ]);
                            foreach($points as $point) {
                                $point->save(false);
                            }
                            return [
                                'result' => [
                                    'message' => 'Дані успішно збережені',
                                ],
                            ];
                        } else {
                            $response->setStatusCode(400);
                            return 'Помилка даних, дані не збережено.';
                        }
                    }
                }
            }
            $response->setStatusCode(404);
            return $response->statusText;
        }

        public function actionSnap(string $path, int $road_passport_id = 2)
        {
            $request = \Yii::$app->request;
            $response = \Yii::$app->response;
            $response->format = $response::FORMAT_JSON;
            $road_passport = RoadPassport::findOne($road_passport_id);
            if(empty( $road_passport )) {
                $response->setStatusCode(404);
                return $response->statusText;
            }
            $google_road = new GoogleRoad($path);
            $result = json_decode($google_road->execute());
            $points = [ ];
            if($result->snappedPoints) {
                foreach($result->snappedPoints as $index => $value) {
                    $points[ $index + 1 ] = new Point([
                        'road_passport_id' => $road_passport_id,
                        'lat'              => $value->location->latitude,
                        'lng'              => $value->location->longitude,
                        'num'              => ( $index + 1 ),
                        'km'               => $index ? NULL : $road_passport->begin,
                    ]);
                }
            }
            $dataProvider = new ArrayDataProvider([
                'allModels'  => $points,
                'key'        => 'num',
                'pagination' => false,
            ]);
            return [
                'result' => [
                    'html'     => $this->renderAjax('list', [
                        'dataProvider'  => $dataProvider,
                        'passport_id'   => $road_passport_id,
                        'road_passport' => $road_passport,
                    ]),
                    'points'   => $dataProvider->getModels(),
                    'passport' => $road_passport,
                ],
            ];
        }

    }
