<?php

    namespace frontend\controllers;

    use common\models\Region;
    use common\models\Road;
    use common\models\RoadDirection;
    use common\models\Settlement;
    use Yii;
    use common\models\FlowIntensity;
    use common\models\FlowIntensitySearch;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use yii\filters\VerbFilter;

    /**
     * FlowIntensityController implements the CRUD actions for FlowIntensity model.
     */
    class FlowIntensityController extends Controller
    {

        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'verbs' => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'POST' ],
                    ],
                ],
            ];
        }

        /**
         * Lists all FlowIntensity models.
         * @return mixed
         */
        public function actionIndex()
        {
            $searchModel = new FlowIntensitySearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

            return $this->render('index', [
                'searchModel'  => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }

        /**
         * Displays a single FlowIntensity model.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionView($id)
        {
            return $this->render('view', [
                'model' => $this->findModel($id),
            ]);
        }

        /**
         * Creates a new FlowIntensity model.
         * If creation is successful, the browser will be redirected to the 'view' page.
         * @return mixed
         */
        public function actionCreate()
        {
            $model = new FlowIntensity();

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();
            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();
            $road_directions = RoadDirection::find()
                                            ->select([
                                                'direction_name',
                                                'road_direction_id',
                                            ])
                                            ->asArray()
                                            ->indexBy('road_direction_id')
                                            ->column();
            $settlements = Settlement::find()
                                     ->select([
                                         'name',
                                         'settlement_id',
                                     ])
                                     ->asArray()
                                     ->indexBy('settlement_id')
                                     ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->flow_intensity_id,
                ]);
            } else {
                return $this->render('create', [
                    'model'           => $model,
                    'roads'           => $roads,
                    'regions'         => $regions,
                    'road_directions' => $road_directions,
                    'settlements'     => $settlements,
                ]);
            }
        }

        /**
         * Updates an existing FlowIntensity model.
         * If update is successful, the browser will be redirected to the 'view' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionUpdate($id)
        {
            $model = $this->findModel($id);

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();
            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();
            $road_directions = RoadDirection::find()
                                            ->select([
                                                'direction_name',
                                                'road_direction_id',
                                            ])
                                            ->asArray()
                                            ->indexBy('road_direction_id')
                                            ->column();
            $settlements = Settlement::find()
                                     ->select([
                                         'name',
                                         'settlement_id',
                                     ])
                                     ->asArray()
                                     ->indexBy('settlement_id')
                                     ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->flow_intensity_id,
                ]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                    'roads'           => $roads,
                    'regions'         => $regions,
                    'road_directions' => $road_directions,
                    'settlements'     => $settlements,
                ]);
            }
        }

        /**
         * Deletes an existing FlowIntensity model.
         * If deletion is successful, the browser will be redirected to the 'index' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionDelete($id)
        {
            $this->findModel($id)
                 ->delete();

            return $this->redirect([ 'index' ]);
        }

        /**
         * Finds the FlowIntensity model based on its primary key value.
         * If the model is not found, a 404 HTTP exception will be thrown.
         *
         * @param integer $id
         *
         * @return FlowIntensity the loaded model
         * @throws NotFoundHttpException if the model cannot be found
         */
        protected function findModel($id)
        {
            if(( $model = FlowIntensity::findOne($id) ) !== NULL) {
                return $model;
            } else {
                throw new NotFoundHttpException('The requested page does not exist.');
            }
        }
    }
