<?php

    namespace frontend\controllers;

    use common\models\Region;
    use common\models\Road;
    use common\models\Settlement;
    use common\models\StateCommon;
    use common\models\SurfaceType;
    use Yii;
    use common\models\BusStop;
    use common\models\BusStopSearch;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use yii\filters\VerbFilter;

    /**
     * BusStopController implements the CRUD actions for BusStop model.
     */
    class BusStopController extends Controller
    {

        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'verbs' => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'POST' ],
                    ],
                ],
            ];
        }

        /**
         * Lists all BusStop models.
         * @return mixed
         */
        public function actionIndex()
        {
            $searchModel = new BusStopSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

            return $this->render('index', [
                'searchModel'  => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }

        /**
         * Displays a single BusStop model.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionView($id)
        {
            return $this->render('view', [
                'model' => $this->findModel($id),
            ]);
        }

        /**
         * Creates a new BusStop model.
         * If creation is successful, the browser will be redirected to the 'view' page.
         * @return mixed
         */
        public function actionCreate()
        {
            $model = new BusStop();

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();

            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();

            $settlements = Settlement::find()
                                     ->select([
                                         'name',
                                         'settlement_id',
                                     ])
                                     ->asArray()
                                     ->indexBy('settlement_id')
                                     ->column();

            $surface_types = SurfaceType::find()
                                        ->select([
                                            'name',
                                            'surface_type_id',
                                        ])
                                        ->asArray()
                                        ->indexBy('surface_type_id')
                                        ->column();

            $state_commons = StateCommon::find()
                                        ->select([
                                            'value',
                                            'state_common_id',
                                        ])
                                        ->asArray()
                                        ->indexBy('state_common_id')
                                        ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->bus_stop_id,
                ]);
            } else {
                return $this->render('create', [
                    'model'         => $model,
                    'roads'         => $roads,
                    'regions'       => $regions,
                    'settlements'   => $settlements,
                    'surface_types' => $surface_types,
                    'state_commons' => $state_commons,
                ]);
            }
        }

        /**
         * Updates an existing BusStop model.
         * If update is successful, the browser will be redirected to the 'view' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionUpdate($id)
        {
            $model = $this->findModel($id);

            $roads = Road::find()
                         ->select([
                             'name',
                             'road_id',
                         ])
                         ->asArray()
                         ->indexBy('road_id')
                         ->column();

            $regions = Region::find()
                             ->select([
                                 'name',
                                 'region_id',
                             ])
                             ->asArray()
                             ->indexBy('region_id')
                             ->column();

            $settlements = Settlement::find()
                                     ->select([
                                         'name',
                                         'settlement_id',
                                     ])
                                     ->asArray()
                                     ->indexBy('settlement_id')
                                     ->column();

            $surface_types = SurfaceType::find()
                                        ->select([
                                            'name',
                                            'surface_type_id',
                                        ])
                                        ->asArray()
                                        ->indexBy('surface_type_id')
                                        ->column();

            $state_commons = StateCommon::find()
                                        ->select([
                                            'value',
                                            'state_common_id',
                                        ])
                                        ->asArray()
                                        ->indexBy('state_common_id')
                                        ->column();

            if($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect([
                    'view',
                    'id' => $model->bus_stop_id,
                ]);
            } else {
                return $this->render('update', [
                    'model'         => $model,
                    'roads'         => $roads,
                    'regions'       => $regions,
                    'settlements'   => $settlements,
                    'surface_types' => $surface_types,
                    'state_commons' => $state_commons,
                ]);
            }
        }

        /**
         * Deletes an existing BusStop model.
         * If deletion is successful, the browser will be redirected to the 'index' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionDelete($id)
        {
            $this->findModel($id)
                 ->delete();

            return $this->redirect([ 'index' ]);
        }

        /**
         * Finds the BusStop model based on its primary key value.
         * If the model is not found, a 404 HTTP exception will be thrown.
         *
         * @param integer $id
         *
         * @return BusStop the loaded model
         * @throws NotFoundHttpException if the model cannot be found
         */
        protected function findModel($id)
        {
            if(( $model = BusStop::findOne($id) ) !== NULL) {
                return $model;
            } else {
                throw new NotFoundHttpException('The requested page does not exist.');
            }
        }
    }
