<?php

use yii\db\Migration;

class m160712_144808_map_relations extends Migration
{
    public function safeUp()
    {
        $this->addForeignKey('road_road_type', 'road', 'road_type_id', 'road_type', 'road_type_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('bus_stop_road', 'bus_stop', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('bus_stop_surface_type', 'bus_stop', 'surface_type_id', 'surface_type', 'surface_type_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('bus_stop_state_common', 'bus_stop', 'state_common_id', 'state_common', 'state_common_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('bus_stop_region', 'bus_stop', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('bus_stop_settlement', 'bus_stop', 'settlement_id', 'settlement', 'settlement_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_surface_road', 'road_surface', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_surface_region', 'road_surface', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_surface_surface_type', 'road_surface', 'surface_type_id', 'surface_type', 'surface_type_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_surface_road_direction', 'road_surface', 'road_direction_id', 'road_direction', 'road_direction_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_surface_surface_treatment', 'road_surface', 'surface_treatment_id', 'surface_treatment', 'surface_treatment_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_surface_state_common', 'road_surface', 'state_common_id', 'state_common', 'state_common_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_passport_road', 'road_passport', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_passport_region', 'road_passport', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('point_road_passport', 'point', 'road_passport_id', 'road_passport', 'road_passport_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_service_road', 'road_service', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_service_region', 'road_service', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_service_road_direction', 'road_service', 'road_direction_id', 'road_direction', 'road_direction_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_service_organization', 'road_service', 'organization_id', 'organization', 'organization_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('settlement_address_link_road', 'settlement_address_link', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('settlement_address_link_region', 'settlement_address_link', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('settlement_address_link_settlement_location', 'settlement_address_link', 'settlement_location_id', 'settlement_location', 'settlement_location_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('settlement_address_link_settlement', 'settlement_address_link', 'settlement_id', 'settlement', 'settlement_id', 'CASCADE', 'CASCADE');
    }

    public function safeDown()
    {
        $this->dropForeignKey('road_road_type', 'road');
        $this->dropForeignKey('bus_stop_road', 'bus_stop');
        $this->dropForeignKey('bus_stop_surface_type', 'bus_stop');
        $this->dropForeignKey('bus_stop_state_common', 'bus_stop');
        $this->dropForeignKey('bus_stop_region', 'bus_stop');
        $this->dropForeignKey('bus_stop_settlement', 'bus_stop');
        $this->dropForeignKey('road_surface_road', 'road_surface');
        $this->dropForeignKey('road_surface_region', 'road_surface');
        $this->dropForeignKey('road_surface_surface_type', 'road_surface');
        $this->dropForeignKey('road_surface_road_direction', 'road_surface');
        $this->dropForeignKey('road_surface_surface_treatment', 'road_surface');
        $this->dropForeignKey('road_surface_state_common', 'road_surface');
        $this->dropForeignKey('road_passport_road', 'road_passport');
        $this->dropForeignKey('road_passport_region', 'road_passport');
        $this->dropForeignKey('point_road_passport', 'point');
        $this->dropForeignKey('road_service_road', 'road_service');
        $this->dropForeignKey('road_service_region', 'road_service');
        $this->dropForeignKey('road_service_road_direction', 'road_service');
        $this->dropForeignKey('road_service_organization', 'road_service');
        $this->dropForeignKey('settlement_address_link_road', 'settlement_address_link');
        $this->dropForeignKey('settlement_address_link_region', 'settlement_address_link');
        $this->dropForeignKey('settlement_address_link_settlement_location', 'settlement_address_link');
        $this->dropForeignKey('settlement_address_link_settlement', 'settlement_address_link');
    }
}
