<?php

use yii\db\Migration;

/**
 * Handles the creation for table `road_width`.
 */
class m160712_142430_create_road_width extends Migration
{

    /**
     * @inheritdoc
     */
    public function safeUp()
    {
        $this->createTable('road_width', [
            'road_width_id' => $this->primaryKey()->comment('Індекс'),
            'region_id' => $this->integer()->comment('Область'),
            'road_id' => $this->integer()->comment('Дорога'),
            'begin' => $this->float()->comment('Місцезнаходженя, км+ початок'),
            'end' => $this->float()->comment('Місцезнаходженя, км+ кінець'),
            'width_roadside_left' => $this->float()->comment('Ширина, узбіччя зліва'),
            'width_reverse_road' => $this->float()->comment('Ширина, проїзна зворотнього напрямку'),
            'width_strip' => $this->float()->comment('Ширина, розподільча смуга'),
            'width_roadway_forward' => $this->float()->comment('Ширина, проїзна прямого напрямку'),
            'width_roadside_right' => $this->float()->comment('Ширина, узбіччя справа'),
            'count_lane_left' => $this->float()->comment('Кількість смуг руху зліва'),
            'count_lane_right' => $this->float()->comment('Кількість смуг руху справа'),

        ]);
        $this->addForeignKey('road_width_region', 'road_width', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_width_road', 'road_width', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
    }

    /**
     * @inheritdoc
     */
    public function safeDown()
    {
        $this->dropForeignKey('road_width_region', 'road_width');
        $this->dropForeignKey('road_width_road', 'road_width');
        $this->dropTable('road_width');
    }
}
