<?php

use yii\db\Migration;

/**
 * Handles the creation for table `road_to_category`.
 */
class m160712_104942_create_road_to_category extends Migration
{
    /**
     * @inheritdoc
     */
    public function safeUp()
    {
        $this->createTable('road_to_category', [
            'road_to_category_id' => $this->primaryKey()->comment('Індекс'),
            'region_id' => $this->integer()->comment('Область'),
            'road_id' => $this->integer()->comment('Дорога'),
            'begin' => $this->float()->comment('Місцезнаходження, км+ початок'),
            'end' => $this->float()->comment('Місцезнаходження, км+ кінець'),
            'distance' => $this->float()->comment('Протяжність, км'),
            'road_category_id' => $this->integer()->comment('Категорія'),
        ]);
        $this->addForeignKey('road_to_category_region', 'road_to_category', 'region_id', 'region', 'region_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_to_category_road', 'road_to_category', 'road_id', 'road', 'road_id', 'CASCADE', 'CASCADE');
        $this->addForeignKey('road_to_category_road_category', 'road_to_category', 'road_category_id', 'road_category', 'road_category_id', 'CASCADE', 'CASCADE');
    }

    /**
     * @inheritdoc
     */
    public function safeDown()
    {
        $this->dropForeignKey('road_to_category_region', 'road_to_category');
        $this->dropForeignKey('road_to_category_road', 'road_to_category');
        $this->dropForeignKey('road_to_category_road_category', 'road_to_category');
        $this->dropTable('road_to_category');
    }
}
