<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "surface_type".
 *
 * @property integer $surface_type_id
 * @property string $name
 *
 * @property CrossSection[] $crossSections
 */
class SurfaceType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'surface_type';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'surface_type_id' => 'Surface Type ID',
            'name' => 'Name',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCrossSections()
    {
        return $this->hasMany(CrossSection::className(), ['surface_type_id' => 'surface_type_id']);
    }
}
