<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "state_common".
 *
 * @property integer $state_common_id
 * @property string $value
 *
 * @property CrossSection[] $crossSections
 */
class StateCommon extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'state_common';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['value'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'state_common_id' => 'Ідентифікатор',
            'value' => 'Значення',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCrossSections()
    {
        return $this->hasMany(CrossSection::className(), ['state_common_id' => 'state_common_id']);
    }
}
