<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "settlement_location".
 *
 * @property integer $settlement_location_id
 * @property string $value
 *
 * @property SettlementAddressLink[] $settlementAddressLinks
 */
class SettlementLocation extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'settlement_location';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['value'], 'required'],
            [['value'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'settlement_location_id' => 'Settlement Location ID',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSettlementAddressLinks()
    {
        return $this->hasMany(SettlementAddressLink::className(), ['settlement_location_id' => 'settlement_location_id'])->inverseOf('settlementLocation');
    }
}
