<?php

    namespace common\models;

    use Yii;

    /**
     * This is the model class for table "settlement_address_link".
     * @property integer            $settlement_address_link_id
     * @property integer            $road_id
     * @property integer            $region_id
     * @property double             $begin
     * @property double             $end
     * @property integer            $settlement_location_id
     * @property integer            $settlement_id
     * @property double             $distance
     * @property Region             $region
     * @property Road               $road
     * @property Settlement         $settlement
     * @property SettlementLocation $settlementLocation
     */
    class SettlementAddressLink extends \yii\db\ActiveRecord
    {

        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'settlement_address_link';
        }

        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'road_id',
                        'region_id',
                        'begin',
                        'end',
                        'settlement_location_id',
                        'settlement_id',
                    ],
                    'required',
                ],
                [
                    [
                        'road_id',
                        'region_id',
                        'settlement_location_id',
                        'settlement_id',
                    ],
                    'integer',
                ],
                [
                    [
                        'begin',
                        'end',
                        'distance',
                    ],
                    'number',
                ],
                [
                    [ 'distance' ],
                    'default',
                    'value' => 0,
                ],
                [
                    [ 'region_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Region::className(),
                    'targetAttribute' => [ 'region_id' => 'region_id' ],
                ],
                [
                    [ 'road_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Road::className(),
                    'targetAttribute' => [ 'road_id' => 'road_id' ],
                ],
                [
                    [ 'settlement_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Settlement::className(),
                    'targetAttribute' => [ 'settlement_id' => 'settlement_id' ],
                ],
                [
                    [ 'settlement_location_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => SettlementLocation::className(),
                    'targetAttribute' => [ 'settlement_location_id' => 'settlement_location_id' ],
                ],
            ];
        }

        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'settlement_address_link_id' => 'Індекс',
                'road_id'                    => 'Автомобільна дорога',
                'region_id'                  => 'Область',
                'begin'                      => 'Місцезнаходження, км+ початок',
                'end'                        => 'Місцезнаходження, км+ кінець',
                'settlement_location_id'     => 'Місце',
                'settlement_id'              => 'Назва населенного пункту',
                'distance'                   => 'Відстань від проїзної частини до забудови, м',
            ];
        }

        /**
         * @return \yii\db\ActiveQuery
         */
        public function getRegion()
        {
            return $this->hasOne(Region::className(), [ 'region_id' => 'region_id' ])
                        ->inverseOf('settlementAddressLinks');
        }

        /**
         * @return \yii\db\ActiveQuery
         */
        public function getRoad()
        {
            return $this->hasOne(Road::className(), [ 'road_id' => 'road_id' ])
                        ->inverseOf('settlementAddressLinks');
        }

        /**
         * @return \yii\db\ActiveQuery
         */
        public function getSettlement()
        {
            return $this->hasOne(Settlement::className(), [ 'settlement_id' => 'settlement_id' ])
                        ->inverseOf('settlementAddressLinks');
        }

        /**
         * @return \yii\db\ActiveQuery
         */
        public function getSettlementLocation()
        {
            return $this->hasOne(SettlementLocation::className(), [ 'settlement_location_id' => 'settlement_location_id' ])
                        ->inverseOf('settlementAddressLinks');
        }

        public function getBeginString()
        {
            return floor($this->begin) . '+' . ( str_pad(round(( $this->begin - floor($this->begin) ) * 1000), 3, '0', STR_PAD_LEFT) );
        }

        public function getEndString()
        {
            return floor($this->end) . '+' . ( str_pad(round(( $this->end - floor($this->end) ) * 1000), 3, '0', STR_PAD_LEFT) );
        }
    }
